# Per- and polyfluoroalkyl substances thermal destruction at water resource recovery facilities: A state of the science review

Lloyd J. Winchell,1\* Katherine Y. Bell 1

John J. Ross,' Martha J.M.Wells, XavierFonoll, John W.NortonJr

1 Brown and Caldwell, Walnut Creek, California   
2EnviroChemervices,Cokeville, Tennessee   
3Great Lakes Water Authorityetroit, Michigan

Received 2 July 2020; Revised 5 November 2020; Accepted 7 November 2020

Correspondence to: Lloyd J.Winchell, Brown and Caldwell, Walnut Creek, CA. Email: Iwinchell@brwncald.com

$^ { * } \mathsf { A l l }$ the authors are WEF members.

Published online 31 December 2020 in Wiley Online Library (wileyonlinelibrary. com)

DOI: 10.1002/wer.1483 $\circled{1}$ 2020 Brown and Caldwell. Water Environment Research published by Wiley Periodicals LLCon behalf of Water Environment Federation.

This is an open access article under the terms of the Creative Commons Atribution License,which permits use,distribution and reproduction in any medium,provided the original work is properly cited.

# ·Abstract

Per- and polyfluoroalkyl substances (PFAS) are a recalcitrant group of chemicals and can be found throughout the environment. They often colect in wastewater systems with virtually no degradation prior to environmental discharge. Some PFAS partitions to solids captured in wastewater treatment which require further processing. Of all the commonly applied solids treatment technologies,incineration offers the only possibility to completely destroy PFAS.Litle is known about the fate of PFAS through incineration,in particular,for the systems employed in water resource recovery facilities (WRRF).This review covers available research on the fate of PFAS through incineration systems with a focus on sewage sludge incinerators.This research indicates that at least some PFAS destruction will occur with incineration approaches used at WRRFs. Furthermore,PFAS in flue gas,ash,or water streams used for incinerator pollution control may be undetectable.Future research involving full-scale fate studies will provide insight on the efficacy of PFAS destruction through incineration and whether other compounds of concern are generated. $^ ©$ 2020 Brown and Caldwell.Water Environment Research published by Wiley Periodicals LLC on behalf ofWater Environment Federation.

# · Practitioner points

·Thermal processing is the only commercial approach available to destroy PFAS.   
·Thermal degradation conditions required for destruction of PFAS during incineration processes are discussed. Fate of PFAS through water resource recovery facility incineration technologies remains unclear. Other thermal technologies such as smoldering combustion,pyrolysis,gasification, and hydrothermal liquefaction provide promise but are in developmental phases.

# · Key words

combustion; emissions; incineration; PFAS; products of incomplete combustion; residence time; temperature; thermal by-products; turbulence; wastewater

# INTRODUCTION

PER- and polyfluoroalkyl substances (PFAS) encompass a wide range of compounds, numbering in the thousands, that have been used in a large variety of consumer and industrial products and,consequently,are widely distributed in the environment (Buck et al.,2011).

As a result of the persistence and toxicity of these compounds, the Stockholm Convention,which manages risks of persistent organic pollutants through a global legally binding instrument, has restricted production of perfluorooctanesulfonic acid (PFOS) (UNEP, 2009) and banned the production of perfluorooctanoic acid (PFOA) (UNEP,20l9).Other actions are planned for perfluorohexane sulfonyl fluoride (PFHxSF) (UNEP,2018).The United States Environmental Protection Agency (USEPA)

followed suit by releasing the PFAS Action Plan: Program Update (USEPA,2020b),which is the first time in USEPAs 50-year history that it has tapped all program offices to address an emerging contaminant of concern.As a result,many of the major fluoropolymer and telomer manufacturers have committed to phasing out long-chain polyfluorinated substances through public or private initiatives.However, international production of PFAS continues in countries such as China (Swedish Chemical Agency, 2015) that have initiated production of perfluorohexane sulfonic acid (PFHxS) precursors and other PFAS compounds as replacement products,which may present concerns of their own.

While global phase-outs are being implemented for some of the significant long-chain compounds,widespread distribution and health concerns (Buck et al.,20lla) have led government agencies to start regulating PFAS in drinking water. Although there are suffcient data for risk assessment of PFOA,PFOS,and several other PFAS,most PFAS detected in drinking water lack adequate data for proper risk characterization (ASTDR,2018; Post et al.,20l7).The European Union (EU) reached a provisional agreement in 2019 by seting a legally binding cumulative drinking water limit of $1 0 0 ~ \mathrm { { n g / L } }$ for the sum of 20 PFAS,and within 3 years regulators are mandated to develop testing protocols as well as establish a legal limit for 4,70o PFAS(The Greens/EFA in the European Parliament, 2019).In the United States (U.S.), the USEPA issued a health advisory level (HAL) of $7 0 \mathrm { n g / L }$ for the sum of PFOA and PFOS in drinking water; however, because HALs are nonenforceable limits and USEPA's Maximum Contaminant Level (MCL) promulgation process is expected to take years, many U.S. states are establishing their own regulatory limits for PFOA,PFOS, and others that are well below USEPAs HAL(Cordner et al.,2019).

Research focused on understanding the sources of these compounds in drinking water has identified municipal water resource recovery facilities (WRRF) as an important pathway (Clara et al.,2oo8).WRRFs provide several conduits for introducing PFAS to the environment: point source discharges of effluent,leakage or unintended releases from surface impoundments or sewer systems,air emissions,disposal of biosolids, and other by-products generated during the treatment process. PFAS are proven to exist in the effluent (Arvaniti & Stasinakis, 2015)and sludge (Eriksson et al.,2017;Hamid &Li,2016; Lee et al.,2014) from WRRFs.Concentrations of selected PFAS increase during treatment and are generally higher in WRRF effluent than influent (Eriksson et al.,20l7; Gallen et al.,2018; Kim Lazcano et al.,2019; Loganathan et al.,2007; Schultz et al.,2006; Venkatesan & Halden,2013; Wang et al., 2018). The increases in concentration during treatment are attributed to the likelihood of precursors transforming in the wastewater treatment process (Eriksson et al.,20l7； Loganathan et al.,2007).PFAS partition from wastewater and adsorb to the wastewater solids differentiated by hydrophobic and electrostatic interactions (Eriksson et al.,2017; Guo et al., 2010; Kim Lazcano et al.,2019; Loganathan et al., 2007; Nakayama et al., 2019; Pan etal.,20l6).The composition of PFAS in wastewater or the solids derived thereof is a function of the WRRF treatment processes,the type and concentration of PFAS received by the WRRF, the biological and chemical transformation to intermediate and terminal degradation products,and the physical or chemical partitioning of congeners (Chen et al.,20l3; Dimzon et al.,2017; Oliaei et al.,2013; Schultz et al.,2006).

Because PFAS may be concentrated in solids captured in wastewater treatment processes (Rainey, 2019),WRRFs might introduce these compounds to the environment through the land application of biosolids,potentially allowing PFAS to enter surface water through runoff or infiltrate to groundwater (Lindstrom et al.,2011).What has not been well studied is the potential for sewage sludge incinerators (SSI) to act as a source of these compounds to the environment.

In North America, there are more than $1 0 0 ~ { \mathrm { S S I s } }$ in operation that combust dewatered sewage sludge,or the solids generated during wastewater treatment.Thermal combustion has been reported as a critical method for destroying PFAS (USEPA,202Oc)and is important in processes such as regeneration of spent granular activated carbon (GAC) used in drinking water and in remediation treatment processes.In other words, SSIs may present a unique opportunity to destroy PFAS.

Despite the highly oxidized nature of PFOA and PFOS, theseand other PFAS display a relatively high thermal reactivity (Lee et al.,20l2).The temperature used for thermal incineration of PFAS in carbon regeneration is usually higher than $1 { , } 0 0 0 ^ { \circ } \mathrm { C }$ (Lee et al.,20l3); however, in laboratory studies,more than $9 9 \%$ of PFOS is degraded at $6 0 0 ^ { \circ } \mathrm { C }$ (Taylor& Yamada, 2003).Studies have shown the required degradation temperature increases with increasing perfluoroalkyl chain lengths (Rayne & Forest,2009).

While thermal combustion of PFAS has been studied for regeneration of spent activated carbon in oxygen-poor atmospheres,limited information is available on the fate of PFAS through SSIs.SSIs are expected to destroy at least some of the PFAS in wastewater solids,given the available research.For example,Takemine et al. (20l3) observed $9 0 \%$ mineralization of PFOA in an airstream at $7 0 0 ^ { \circ } \mathrm { C }$ ，Alkali addition enhanced destruction of halogenated compounds (Kamarehie et al.,2014; Takata et al.,2015; Yin etal.,2013),and laboratory-scale incineration of lime-conditioned sludge promotes fluorine mineralization from PFOS (Wang et al.,20i3). Other chemical groups may serve as analogs to supplement PFAS-specific research.For example, full-scale waste incinerators and cement kilns have been reported to destroy chlorofluorocarbons at greater than $9 9 . 9 9 \%$ efficiency (Ueno et al.,1997; Urano et al.,2011).

The extent of PFAS thermal destruction (i.e., thermal degradation by-product formation or complete mineralization) is also poorly understood.No published data currently exist on the overall fate of PFAS through an SSI,although limited information from other industries can be referenced.The primary point of release from an incineration system is the flue gas emitted from the stack,where any recalcitrant PFAS or by-products from the incineration process would be released directly to the environment. Some researchers have shown that off-gas from incineration of PFAS-containing textiles emitted no detectable PFOA(Taylor et al.,2014). Conversely, Garcia et al. (2007) observed significant PFAS emissions,roughly $2 2 \%$ of the parent compound on a carbon basis,in laboratory-scale studies from thermal degradation of polytetrafluoroethylene (PTFE) under substoichiometric oxygen conditions at temperatures ranging from 750 to $1 { , } 0 5 0 ^ { \circ } \mathrm { C }$ Recently,air concentrations of PFAS were determined at,and upwind of, municipal solid waste (MSW) incineration plants.Higher concentrations were found at the facilities than upwind (Wang et al.,2020).

Tracking the fate of PFAS through any system is,in part,limited by available sampling and analytical methods. Agencies developing standardized methods for analyzing specific PFAS congeners include USEPA,American Society for Testing and Materials (ASTM),and the International Organization for Standardization (ISO).In the case of SSIs, these methods need to be adapted for the solids or aqueous phase samples that represent the inputs/outputs of the incineration process.Current analyses only measure a fraction of the PFAS present,partially due to the limited availability of analytical standards. Other nonquantitative or surrogate indicator approaches,such as nontargeted or total fluorine analyses,could be used to elucidate the fate of PFAS through an incineration system.

This literature review aims to identify the current understanding regarding the fate of PFAS through SSI systems.With this review, the WRRF owners will have a comprehensive understanding of the state of the art of PFAS thermal behavior and of approaches likely to be useful in understanding their fate through SSIs.

# PFAS DIVERSITY

The following introduction to the PFAS chemical family is intended to help the reader better understand the fate of PFAS through an SSI. This introduction includes basic chemical structure,terminology,and classification within the PFAS family.

Every PFAS contains a common structural element, the perfluoroalkyl group $( \mathrm { C } _ { \mathrm { n } } \mathrm { F } _ { 2 \mathrm { n } + 1 } )$ (Buck et al.,2011b; Horst et al., 2018)and has a linear or a branched alkyl chain (Kissa,2001). PFAS comprise an extensive family tree,the roots of which are illustrated in Figure 1.The USEPA has compileda consolidated master listof nearly 8,OoO chemicals that fit into the PFAS category (USEPA,2020d).Beyond the scope of this review, more comprehensive schematics of PFAS families of compounds are found in the literature (ITRC,2020; OECD,2018; Wang et al., 2017).

The primary familial classification is between the polymer and nonpolymer types of PFAS.Polymeric PFAS are potential precursors of nonpolymeric PFAS when they degrade.Nonpolymer PFAS are subdivided into perfluoroalkyl acids (PFAAs),PFAA precursors,and other potential PFAS (Figure 1).Two of the most well-known PFAA members are PFOA,an example of the perfluoroalkyl carboxylic acid (PFCA) family,and PFOS,an example of the perfluoroalkane sulfonic acid (PFSA) family.

PFAS chemical structure and characteristics are diverse. Typical functional groups in PFAS include OH, $\mathrm { C O } _ { 2 } \mathrm { H } .$ Cl,O, N,and $\mathrm { S O } _ { 3 } \mathrm { H }$ PFAS congeners exhibit many different chemical properties.PFAS can differ in polarity-polar or nonpolar; charge state-neutral,anionic,cationic,or zwitterionic；and volatility-volatile,semi-volatile,or nonvolatile.

The alkyl carbon atoms in perfluoroalkyl substances are fully fluorinated,whereas they are not fully fluorinated in polyfluoroalkyl substances. In perfluoroalkyl substances,a hydrophilic functional group such as $- \mathrm { C O } _ { 2 } \mathrm { H }$ or $- \mathrm { S O } _ { 3 } \mathrm { H }$ links to the hydrophobic $\mathrm { C } _ { \mathrm { n } } \mathrm { F } _ { 2 \mathrm { n } + 1 }$ group; however, in polyfluoroalkyl substances, the $\mathrm { C } _ { \mathrm { n } } \mathrm { F } _ { 2 \mathrm { n } + 1 }$ group connects to at least one nonfluorinated alkyl carbon (-C-H) linking the perfluorinated group and the hydrophilic functional group (Dauchy, 2019; Pancras et al.,20l6).Polyfluoroalkyl substances comprise a far more diverse group than the perfluoroalkyl substances (Ross et al.,20l8),and polyfluoroalkyl substances can degrade into perfluoroalkyl substances (Dauchy, 2019).Another emerging subclass of PFAA compounds is the perfluoroether carboxylic acids; GenX, the ammonium salt of hexafluoropropylene oxide dimer acid (HFPO-DA) fluoride,introduced to the commercial market as a replacement for PFOA, is an example.

![](images/0ae5d222de2dc54e94aa6003514459487bcc4d41265ec98d3acaf7fb691ba6ee.jpg)  
Figure 1.PFAS family schematic.

Other PFAA precursors can generate PFAA compounds during processing and in the environment. One such subgroup is the fluorotelomers,which are polyfluorinated molecules with an ethyl $\left( - \mathrm { C H } _ { 2 } \mathrm { - C H } _ { 2 } - \right)$ group between the fully fluorinated carbon chain and a variety of different functional groups.For example,the 8:2 fluorotelomer alcohol has a 2-carbon ethyl alcohol group attached to 8 fluorinated carbons.

# THERMAL PROCESSES

Thermal processes utilize energy in the form of heat to transform materials.There are several types of thermal processes relevant to wastewater solids processing and which are typically identified by the involvement of oxygen in the process.

Combustion entails a chemical reaction in which an oxidant, typically oxygen,reacts with a reducing agent (fuel). The chemical reaction breaks apart chemical bonds of the reactants to form more thermodynamically stable end products.In hydrocarbon combustion, the carbon (C)/hydrogen (H) fuel component combines with oxygen to form carbon dioxide $\left( \mathrm { C O } _ { 2 } \right)$ and water $\left( \mathrm { H } _ { 2 } \mathrm { O } \right)$ ,If the reaction is exothermic,the released energy often is sufficient to self-sustain the process once the initial activation energy is provided. SSIs use combustion to process, or stabilize,wastewater solids.The term“incineration” generally refers to combustion of a waste product, so while wastewater solids are often utilized as an energy source,combustion of these solids is typically referred to as incineration.

In the absence of oxygen,or at temperatures lower than required for combustion,materials will still break down when exposed to heat.In the strict absence of oxygen in the chemical reaction, the thermal process is called thermolysis.Calcination of limestone $\left( \mathrm { C a C O } _ { 3 } \right)$ ）to quicklime(CaO) using heat to drive off $\mathrm { C O } _ { 2 }$ is a simple thermolysis example.Pyrolysis and gasification,examples of thermal processes in oxygen-limited environments,have been sparingly applied to wastewater solids.

These processes are managed to generate simpler hydrocarbon substrates for subsequent use.

# OVERVIEW OF SEWAGE SLUDGE INCINERATORS AND RELATED THERMAL TECHNOLOGIES

Wastewater solids are currently processed by several thermal technologies while others are in development. The following describes the dominant combustion technologies employed at SSI facilities,industry analogs,and alternative technologies emerging in the industry.

# Incinerators

Sewage sludge incinerators are a subset of incineration applications,including municipal solid waste incineration,cement kiln co-incineration,and hazardous waste incineration.Detailed discussions can be found in several sources (Albertson,1992; Niessen,2002;WEF,2009).

Municipal WRRFs typically have used two furnace technologies to combust solids captured from liquid treatment. Multiple hearth furnaces (MHF) have a long track record at WRRFs with installations first constructed in the l930s.The first fluidized bed furnace (FBF) was installed at Lynwood, Washington, in 1965. Other furnaces types have been used, but MHF and FBF overwhelmingly represent the combustion technologies in service today at WRRFs. Table 1 summarizes the key operating characteristics of SSIs compared to other incinerators.

The MHF consists of a cylindrical steel shell arranged vertically with refractory lining and multiple levels (Figure 2). Each level,or hearth,is constructed of firebrick.A central shaft extends the full height of the furnace and supports rabble arms extending to the periphery of each hearth.The rabble arms are fixed with plows or teeth to move material inward or outward. Dewatered solids are fed to a hearth near the top of the furnace and are either moved inward or outward (movement direction alternates on each subsequent hearth) to drop through holes onto the hearth below. Water associated with the solids evaporates before the volatile fractions are released and combustion initiates. The number of hearths,which account for evaporation or combustion,vary across installations to achieve different combustion conditions.Combustion control is achieved by the speed at which the rabble arms rotate to move the solids and by burners installed on selected hearths to provide supplemental heat.Noncombustible material (i.e.,ash) continues to the lower hearths,which is also where air is introduced. Combustion gases flow upward and out the exhaust ductwork on the top hearth.

Table 1.Comparison of incinerator technology operating conditions   

<html><body><table><tr><td>INCINERATOR TYPE</td><td>TEMPERATURE</td><td>RESIDENCE TIME</td><td>TURBULENCE</td><td>EXCESS AIR</td></tr><tr><td>MHF</td><td>Upper hearths-300-500℃ Combustion hearths - 700-1,000℃ Bottom hearths -150-300C</td><td>Solids - approximately 1 h Gases- several seconds</td><td>Intense</td><td>50-125%</td></tr><tr><td>FBF</td><td>Sand bed -700-800C Freeboard -800-900C</td><td>Solids - &lt;l min Gases -6-10 s</td><td>Extreme</td><td>40%</td></tr><tr><td>Rotary Kiln</td><td>Kiln - 650-1,300℃ Afterburner - 1,000-1,300C</td><td>Solids - 1-1.5 h Gases - several seconds</td><td>Intense</td><td>50-200%</td></tr><tr><td>Liquid Injection</td><td>Burner- 800-1,200℃</td><td>Gases - 0.3-2.0 s</td><td>Intense</td><td>120-250%</td></tr><tr><td>Moving Grate</td><td>Afterburner- 850℃</td><td>Gases -2 s</td><td>Moderate</td><td>&gt;200%</td></tr></table></body></html>

![](images/ecc65d72302923bca9db36975791fc65a0a3b0001916b2d53d99cae6061ea331.jpg)  
Figure 3. Typical FBF section view.

The MHF provides high solids and gas retention.The combination of the gas flow and mechanical mixing of the rabble arm teeth provide an intensely mixed environment.The temperature profile of an MHF increases from the upper hearths, where water evaporates,to the middle hearths where solids combust.As ash moves to lower hearths countercurrent to the combustion air, temperatures can drop to approximately $1 5 0 ^ { \circ } \mathrm { C }$ for easier handling of the ash.Combustion air requirements for acceptable performance are relatively high compared to an FBF.The higher combustion air volume,quantified as excess air which is calculated as that amount of oxygen provided in excess of stoichiometric combustion requirements,overcomes some of the comparably lower combustion efficiency in an MHF (from less turbulence) than an FBF.Most currently operating MHFs were modified after implementation of the Clean Water Act solids management rules in 1993,which lowered allowable emissions of products of incomplete combustion (PIC). Afterburners were retrofitted either externally, or by using one or more of the top hearths enabled by switching the dewatered solids introduction location to lower hearths.The afterburners typically use natural gas to elevate the flue gas temperature to achieve complete combustion. The afterburners achieve temperatures of $8 2 0 ^ { \circ } \mathrm { C }$ or higher for $_ { 1 - 2 s }$

Fluidized bed furnaces differ significantly from MHFs in configuration (Figure 3). The FBF consists of a vertically oriented cylinder that expands in diameter with increasing height. Three major zones exist in an FBF starting at the bottom with the windbox,which acts as a plenum for the combustion air blown into the furnace. The windbox is capped bya distribution structure typically consisting of a ceiling penetrated by many tubes or tuyeres that extend through the ceiling.Head loss through the tuyeres provides uniform airflow distribution into the second zone,or sand bed,that uses the windbox ceiling as a floor. The flow of air through the three to six feet of sand creates enough drag force to fluidize the material, creating an extraordinarily turbulent or violent environment.Dewatered solids are injected into or immediately above the sand bed. Intense mixing of the sand bed facilitates heat transfer and fuel/air interaction to provide uniform temperatures and thus achieve efficient combustion.FBFs have two significant advantages over MHFs-the comparably lower excess air required, and the ability to operate without supplemental fuel,or autogenously, where dewatered solids provide all the heat needed to maintain temperatures.To operate autogenously,an FBF typically must be coupled with a heat exchanger that preheats combustion air using the waste heat from the furnace flue gas.

The third zone in an FBF is the freeboard, which extends from the top of the sand bed to the furnace roof where an outlet duct exhausts the flue gas.Volatile compounds in the dewatered solids or fixed combustible material ejected from the sand bed combust in the freeboard, resulting in a higher temperature than in the sand bed.A well-operated FBF will maintain the freeboard temperature no more than $1 0 0 ^ { \circ } \mathrm { C }$ higher than the sand bed.The expanding shell of the FBF,most notably in the freeboard region,achieves high gas residence times.To protect downstream equipment, the FBF roof is equipped with spray water to drop the exhaust temperature to roughly $8 5 0 ^ { \circ } \mathrm { C }$

FBFs achieve lower emissions than MHFs because of the highly turbulent sand bed and uniform temperatures that minimize localized cold spots that can result in incomplete combustion.The most recent federal regulations (Standards of Performance for New Stationary Sources $\&$ Emission Guidelines for Existing Sources,20l1) provide more stringent emission limits for FBFs compared with MHFs.From this,one can infer the performance differences from FBFs compared to MHFs.

The dynamics in the FBF and MHF differ significantly from furnaces typically employed to treat hazardous or municipal solid wastes.Rotary kiln furnaces handle solid materials well and often are paired with an afterburner to combust volatile compounds. Operating conditions can be analogous to an MHF (Oppelt,1987).Municipal solid waste can also be incinerated in a sloped moving grate-type furnace (USEPA,2020a). The EU mandates temperatures shall reach $8 5 0 ^ { \circ } \mathrm { C }$ for $_ \mathrm { ~ 2 ~ s ~ }$ (United Kingdom Department for Environment Food & Rural Affairs,2013).Niessen (2002) provides an extensive discussion on grate type furnaces.Liquid injection hazardous waste furnaces spray or atomize particle-free waste into a burner flame or mix the waste with the supplemental fuel before the burner with operating conditions typical of those used in afterburners coupled with other incineration technologies (Oppelt,1987). Neither the rotary kiln nor moving grate furnaces will match the turbulence of an FBF and may be more tranquil than an MHF.Long residence times and turbulent conditions in FBFs and MHFs favor more complete combustion.As a result, the combustion efficiency may be higher in SSIs for a given temperature compared with hazardous or municipal solid waste incinerators.

Current incineration systems are required to meet emissions criteria with extensive air pollution control measures.All SSIs in the United States known to the authors employ some type of wet scrubber for air pollution control. Sandblom (2014) hypothesized that any PFAS compounds escaping the furnace would be captured in the wet scrubber due to their low $\mathrm { p K } _ { \mathrm { a } }$ values.Many SSIs also include equipment to remove mercury from the flue gas,which requires an activated carbon or sorbent polymer composite(SPC） system.Activated carbon removal of PFAS is well accepted for drinking water applications,and removal can be expected from the gas phase,as well.The SPC mercury removal system has yet to be investigated for PFAS removal efficiency. Some facilities use wet electrostatic precipitators downstream of the wet scrubber to capture fine particulates that could include adsorbed PFAS compounds. Currently, no published work on PFAS removal within an incineration application across the stated pollution control equipment exists.

# Emerging thermal treatment techniques

Several alternative thermal treatment processes for wastewater solids are currently in development or being implemented at a limited scale.Drivers for the evolution of these technologies have been the improved economics of wastewater solids management and energy efciency;however,they are currently gaining increased attention for their potential as alternative PFAS destruction technologies.However,to date,none of these techniques have been proven to be commercially viable for widespread application with wastewater solids.

# Thermal drying with combustion systems

Wastewater solids can be dried to reduce mass and create a beneficial reuse product.When dried,wastewater solids have a substantial heating value (14,0o0-21,0oo kilojoules per kilogram),similar to that of low-grade coal (Heidrich et al., 2011; NACWA,2010).Dried product furnaces have been installed in drying facilities to combust the dried product and capture the resulting heat for recycling back to the drying process. These systems contain a primary combustion chamber where dried product is combusted at temperatures of $7 6 0 { - } 9 8 0 ^ { \circ } \mathrm { C } ,$ and typically postcombustion of the flue gas (at temperatures up to $1 { , } 1 5 0 ^ { \circ } \mathrm { C } )$ is performed before treatment and exhaust. The units currently are regulated under the same air emissions requirements as SSIs and require substantial air pollution control processes,typically including urea,alkaline,coke dosing, and textile filtration. Viswanathan et al.(2020) reported on progress in development of a laboratory-scale combustion reactor designed to simulate oxidative conditions similar to those occurring in a commercial dried product furnace to measure PFAS destruction,with publication of the results expected shortly.

# Pyrolysis and gasification

Pyrolysis and gasification are thermal decomposition processes that convert solid carbon feedstocks into a combustible gas. Pyrolysis submits carbonaceous materials to high temperatures $( 2 0 0 \mathrm { - } 1 , 1 0 0 ^ { \circ } \mathrm { C } )$ in the absence of oxygen and generates a carbon-rich,porous product called biochar. Gasification introduces a limited quantity of oxidant (typically air) at high temperatures $( 8 0 0 - 1 , 6 5 0 ^ { \circ } \mathrm { C } )$ to refine the volatile organic fraction through partial oxidation and reforming reactions while converting the solid mass to ash particles.Thermal treatment of wastes in a reductive environment has garnered interest from the waste management sector for its potential to guard against the formation of harmful oxidation by-products such as dioxins and furans (Maric et al.,2020; Rey et al.,2016).

The basic pathway for thermal PFAS destruction in a reductive environment is hydrodefluorination (HDF).HDF is the conversion of a carbon-fluorine(C-F) bond into a carbon-hydrogen (C-H) bond and can be performed with a variety of reagents (and catalysts).For the reaction to proceed, the resulting element-fluorine bond formation must be suficiently exothermic to generate the thermodynamic compensation required for the C-F cleavage,with common reagent elements including H, silicon,or boron (Kuehnel et al.,2013). The process requires a H source for the C-H bond,which often also serves as the fluorine acceptor (Kennedy et al., 1997; Kuehnel et al.,20l3).H can be produced during pyrolysis through the steam reforming reaction,where the steam released from the moisture in feed materials generate H through reactions with primary pyrolysis decomposition products (Conesa & Font, 2001; Pinder,20l2; Rey et al.,2016).

A variant on the pyrolysis process,called gas-phase reduction (GPR),introduces hydrogen gas directly into the thermal reactor and has been used to break down chlorinated hydrocarbons like polychlorinated biphenyls (PCB) (NRC,1996). Laboratory-scale studies conducted in Canada to assess the effectiveness of applying GPR to dried biosolids successfully produced hydrogen-enriched methane gas but consumed a similar amount of $\mathrm { H } _ { 2 }$ during the process, indicating that many of the energy recovery benefits of pyrolysis would be offset in GPR unless a well-functioning H recovery system was present (Pinder, 20l2). Catalytic hydrogenation,reduction with metals or low-valent metal compounds, has also been proposed for hydrodefluorination of PFAS compounds (Alonso et al., 2002; Lee & Choi, 2002).Wang et al.(2015a) demonstrated transformation efficiencies upward of $8 0 \%$ when submitting a mixture of PFAS and calcium compounds to thermal treatment at temperatures at $6 0 0 ^ { \circ } \mathrm { C }$ and higher.

Central to the potential for PFAS decomposition in pyrolysis and gasification systems is their ability to maintain PFAS within the hot zone ofthe reactor before volatilizing and exiting. Organic materials introduced into a pyrolysis reactor undergo various stages of thermal decomposition due to changing feedstock characteristics and moisture content. Studies show that pyrolysis causes PFAS volatilization at temperatures below $4 5 0 ^ { \circ } \mathrm { C } ,$ while the volatilization of organic feedstocks can require internal temperatures of up to $6 0 0 ^ { \circ } \mathrm { C }$ (Gao et al.,2020; Wang, Cousins, et al.,20l5). Consequently, typical design parameters related to the residence time of organic feedstocks may not correlate to those required for PFAS destruction,and further study is required to investigate the potential for PFAS transformation concerning reactor design.

Limited experimental data are available on PFAS removal during pyrolysis and gasification. Kim et al. (2015) conducted laboratory pyrolysis experiments with wastewater solids at 300 and $7 0 0 ^ { \circ } \mathrm { C }$ and found no significant change of residual PFAS concentration in the biochar; however, no discussion was provided on why PFAS were still detected, given general agreement in the literature that PFAS compounds volatilize at temperatures ${ < } 7 0 0 { } ^ { \circ } \mathrm { C }$ 、A pyrolysis technology supplier recently published biochar sampling data from a system operating at $8 5 0 ^ { \circ } \mathrm { C }$ that demonstrated PFAS removal to nondetect levels, indicating transformation or volatilization of the compounds (Bioforcetech,2020).If the PFAS,or partial decomposition products,do volatilize and exit the reactor in the pyrolysis gas,they would likely be submitted to gas combustion applications for energy recovery resulting in further destruction or transformation.

While syngas produced from simpler feedstocks such as woody waste and algal biomass has been refined to produce high-value gas or liquid fuels,wastewater solids generate a high load of inorganic contaminants that make internal combustion applications dificult. Consequently, demonstration and commercial scale systems have used a thermal oxidizer to combust the syngas and capture the heat for use in upstream drying processes or conversion to electricity through the organic Rankine cycle(ORC) process. Thermal oxidizers are typically operated to achieve temperatures of $8 5 0 ^ { \circ } \mathrm { C }$ or greater for more than 2 s and can achieve a greater degree of efficiency than incineration,given their ability to introduce process gases through or very near the ignition zone.Thermal oxidizers are often permitted for $9 9 . 9 9 \%$ emission reduction,and a recent test report of a thermal oxidizer used to control PFAS process stream emissions from an industrial facility demonstrated compliance with this requirement (Focus Environmental Inc.,2020). Consequently, the critical step for achieving PFAS control in pyrolysis and gasification systems may be the operation of the downstream thermal oxidizer.

# Hydrothermal liquefaction

Hydrothermal liquefaction (HTL） subjects solids to high temperatures and pressures $2 5 0 \mathrm { - } 3 5 0 ^ { \circ } \mathrm { C } $ ，10-25 mega Pascals [MPal) to generate a liquid biocrude oil. The process is fed dewatered,slurried solids to generate biocrude,suitable for further refining into jet, diesel,and heavy fuels,while retaining an effluent stream with a high ammonia and chemical oxygen demand (COD) load that must be managed (Toor et al., 2011). During laboratory-scale HTL experiments with wastewater solids,Yu et al.(2020) demonstrated varying levels of PFAS degradation based on analysis of the functional groups of the compounds and operational parameters.Greater than $9 9 \%$ transformation efficiency was observed for PFAS compounds with carboxylate functional groups,specifically PFOA,fluorotelomer carboxylic acid (FTCA),and fluorotelomer unsaturated carboxylic acids (FTUCA). Conversely, less than $3 4 \%$ degradation was observed with the sulfonic acid compound PFOS,even when the temperature was elevated to $3 5 0 ^ { \circ } \mathrm { C }$ for $9 0 ~ \mathrm { { m i n } }$ .Both the original PFAS compounds and defluorinated intermediary products were found in the biocrude oil fraction, which presents a research need for understanding its resulting fate. The authors proposed potential application of reactive amendments to the HTL process to further promote destruction of recalcitrant PFAS compounds such as PFOS during HTL. Zhang et al. (2020) found that amending a plant biomassfed HTL process with potassium hydroxide (KOH) increased removal of perfluorosulfonic acids from ${ < } 2 0 \%$ to $8 6 \%$ ,indicating the potential efficacy of this strategy.

Table 2. Relevant bond energies adapted from Tsang et al.(1998)   

<html><body><table><tr><td>BOND</td><td>ENERGY, KJ/MOL</td><td>BOND</td><td>ENERGY, KJ/MOL</td></tr><tr><td>CF3-F</td><td>552</td><td>H-H</td><td>436</td></tr><tr><td>CF2-F</td><td>352</td><td>OH-H</td><td>499</td></tr><tr><td>CF-F</td><td>508</td><td>CH-H</td><td>439</td></tr><tr><td>H-F</td><td>569</td><td>CCl3-Cl</td><td>288</td></tr><tr><td>F-F</td><td>159</td><td>H-Cl</td><td>431</td></tr><tr><td>HO-F</td><td>216</td><td>HO-Cl</td><td>235</td></tr><tr><td>O-F</td><td>220</td><td>Cl-Cl</td><td>242</td></tr><tr><td>CF3-H</td><td>456</td><td>CCl-H</td><td>392</td></tr><tr><td>CF3-CF3</td><td>408</td><td>CCl3-CCl3</td><td>301</td></tr><tr><td>CH-H</td><td>439</td><td></td><td></td></tr></table></body></html>

# Smoldering combustion

Smoldering combustion propagates thermal oxidation by the diffusion of an oxidant (air) through the surface of a condensed liquid or solid fuel. The process can be engineered by mixing fuel with an inert media like sand to promote mass and thermal transfer and introduce a forced, upward airflow (Wang, 2017).Rashwan et al. (2016) reported that self-propagating smoldering combustion can be achieved with wastewater solids having a solids content as low as $2 0 \%$ by modulating the forced airflow to account for process and feed characteristic fluctuations.Major (2019） investigated smoldering combustion of PFAS-laden activated carbon and a simulated waste soil mixture in a Department of Defense (DoD） Strategic Environmental Research and Development Program (SERDP) study.Results reported all PFAS compounds as nondetect levels from the treated product. The process achieved temperatures over $1 { , } 0 0 0 ^ { \circ } \mathrm { C }$ for one to ten minutes based on separate tests and depending on the location in reactor column. Oxygen concentrations averaged $6 \%$ .Where emissions sampling was conducted for the simulated waste soil experiments, $8 2 \%$ of the available fluorine was captured as hydrogen fluoride (HF). The authors acknowledged the remaining available fluorine fraction indicated incomplete PFAS destruction.The presence of both parent PFAS compounds and fluorinated by-products with one less functional group was identified by emissions sampling.However, compounds over nine carbons were attributed to material impurities and not by-products.A more recent study was conducted using municipal biosolids and demonstrated PFAS removal to nondetect levels in the solid by-product,although no gas-phase analysis was performed (Kinsman et al.,2020).

# DOCUMENTED PFAS THERMAL BEHAVIOR

A significant body of literature exists on PFAS thermal behavior but focuses mostly on laboratory-scale experiments and only considers specific PFAS congeners given analytical limitations.The following organizes the available literature considering first the early theoretical work. Subsequently,this review presents laboratory work used as a basis for current incineration guidelines,full-scale incineration studies,and finally a summary ofby-products observed during thermal processing.

# Theoretical combustion requirements

For a combustion process to achieve complete PFAS thermal destruction (mineralization), PFAS compounds would have to be driven to their thermodynamic endpoints of $\mathrm { C O } _ { 2 }$ $\mathrm { H } _ { 2 } \mathrm { O }$ ,HF, or sulfur compounds,if present.The introduction of additional chemical compounds such as salts,minerals,and halogens result in other end products,for example,HF as an end-product from organic fluoride compounds.Additionally,some inert fraction,or ash,of the fuel,or waste,remains as a solid product.

The combustion process, while seemingly simple, involves thousands of elementary physical and chemical reactions, reaction kinetics,fluid dynamics,and heat transfer mechanisms (Burgess et al.,1995; Reed, 1978).Residence time, turbulence (mixing),and stoichiometry (the relative mixture of waste to fuel,oxygen,and other gas-phase constituents）within the flame zone all impact the completeness of the combustion process,and consequently, the temperature and destruction efficiency achieved (Lewis,20o8; Niessen,2002).

Given the dynamic nature of the incineration process as well as varying characteristics of input waste streams, operational parameters vary over time throughout the reactor (Lewis, 2008;Tsang et al.,1998).Additionally, the potential exists for flame zone failure modes,with the most notable being thermal quenching by pockets of cold unreacted material and inadequate mixing. Consequently, theoretical investigations into thermal destruction are often based on conservative operational assumptions accounting for the occurrence of nonideal conditions in operating systems (Tsang et al.,1998). These conditions lead to the formation of thermal degradation by-products, which are a primary concern in incineration processes.

Early theoretical investigations into the potential for thermal destruction of fluorinated organic compounds focused on one- and two-carbon molecules,given the interest in their use as fire extinguishing agents (Burgess et al.,1995; Tsang et al.,1998).In these studies,thermochemical and kinetic data were compiled to develop a framework for future combustion simulation experiments. The thermal and chemical stability data show notably high bond strengths for both C-Fand H-F bonds (relevant bond energies identified by Tsang et al. (1998) are provided in Table 2).A high degree of energy is required for cleavage of the C-F bond suggesting that stable fluorinated intermediary products may be produced.

The relative stability of intermediary compounds results in less favorable reaction kinetics,which can interrupt or terminate flame chain propagating steps,resulting in the flame-retardant properties of PFAS.Additional research postulated that, due to the relative stability of the compounds,initial decomposition requires unimolecular bond cleavage because fluorinated organics would be less susceptible to bimolecular attack (Tsang et al.,1998).As the fluorinated organics become less saturated, they are more vulnerable to radical attck and reforming reactions.However, Tsang et al. (1998) showed fluorinated organics followed the rule of hydrocarbons in a homologous series—as larger compounds break down into smaller components, those compounds increase in stability. They calculated theoretical temperatures required to achieve $9 9 . 9 9 \%$ destruction of various intermediary products in 1 s via unimolecular decomposition, and perfluoromethane $\mathrm { ( C F _ { 4 } ) }$ resulted in the highest predicted temperature required at $1 { , } 4 4 1 { ^ \circ } \mathrm { C }$ Destruction of $\mathrm { C F _ { 4 } }$ has been noted in other studies to require temperatures ranging from 1,200 to $1 { , } 4 0 0 ^ { \circ } \mathrm { C }$ (Beu,2005; USEPA,2020c).Given this finding, $\mathrm { C F _ { 4 } }$ has been proposed as a potential surrogate for monitoring emissions from fluorinated organics incineration.Although using $\mathrm { C F _ { 4 } }$ alone may underpredict PFAS destruction efficiency, multiple surrogate compounds should be considered, with representatives covering the diverse chemical properties (i.e.volatility, polarity,and ionic charge)of the chemical family.

# Thermal destruction guidelines and experimental basis

Most published research and industry guidance states that complete destruction of PFAS requires operation at the higher temperature ranges $( > 1 , 0 0 0 ^ { \circ } \mathrm { C } )$ ,as summarized in Table 3. Notably, this guidance is based on limited conceptual or laboratory-scale experiments and precedence on previous guidance established for hazardous waste incineration.

The baseline research for these recommendations stems from USEPA and other international environmental agency activities.Under the Toxic Substances Control Act (TSCA), the USEPA worked to identify and reduce PFAS exposure from industry, including working with 3M to phase out the use of PFOS in products and facility emissions beginning in 20ol and continuing with the 2010/2015 PFOA Stewardship Program. After 3M's announcement to phase out the manufacture and use of PFOS,the U.S.and the United Kingdom led efforts within the Organization for Economic Co-operation and Development (OECD) to perform a hazard assessment of PFOS in cooperation with other member countries and industry.A final draft of the assessment was published in 20o2 and noted that laboratory combustion studies were being conducted on PFOS and two polymeric formulations to assess combustion by-products over a range of temperatures (OECD,2002).A final report was published the following year (Taylor & Yamada, 2003)discussing results of a simulated hazardous waste incineration experiment with limited air to account for nonideal combustion conditions.The chemicals were submitted in gaseous form to secondary combustion zone temperatures of 600 and $9 0 0 ^ { \circ } \mathrm { C }$ using methane as the fuel source (primary reactor temperatures of $1 { , } 2 5 0 ^ { \circ } \mathrm { C }$ were used to ensure volatilization). Experiments showed ${ < } 0 . 4 \%$ and $0 . 0 5 \%$ of the PFOS fed to the reactor were detected in the exhaust at tests conducted at 600 and ${ 9 0 0 ^ { \circ } } \mathrm { C } ,$ respectively, indicating a high degree of removal. While a variety of small molecular weight PICs were identified at $6 0 0 ^ { \circ } \mathrm { C } .$ ，the detection of perfluorinated alkanes was limited to $\mathrm { C _ { 1 } }$ and $\mathrm { C } _ { 2 }$ compounds. Two eight-carbon perfluoroalkyl sulfonamides were also studied to see if they acted as precursors for PFOS after combustion.No PFOS was detected, but some tests detected PICs identified as benzene, tetrafluorosilane,and difluorodimethylsilane.Taylor and Yamada (2003)

Table 3.Recent guidance and literature basis for PFAS thermal destruction   

<html><body><table><tr><td>SOURCE</td><td>TEMPERATURE NOTED</td><td>COMMENTARY</td></tr><tr><td>Pancras et al. (2016)</td><td>1,000-1,200℃</td><td>High-temperature incineration is required for complete PFOS degradation</td></tr><tr><td>Kucharzyk et al. (2017)</td><td>1,000℃ or greater</td><td>High-temperature incineration is required to destroy PFAS adsorbed to spent activated carbon</td></tr><tr><td>USEPA (2020c)</td><td>1,000°℃</td><td>Studies found PFOA is removed to nondetect levels using laboratory-scale combustion experiments</td></tr><tr><td>UNEP (2019a)</td><td>1,100℃</td><td>Combustion at hazardous waste incineration process pa- rameters (2 s residence time at temperature) is the most</td></tr><tr><td>Ross et al. (2018)</td><td>1,100℃</td><td>appropriate way to handle PFOS waste High temperatures are required for destruction of gas- phase PFAS</td></tr><tr><td>ITRC (2020)</td><td>1,000℃ or greater</td><td>PFAS destruction can be achieved at high temperature</td></tr></table></body></html>

did not expect reformation of PFOS or other long-chain PFAS because the methane fuel provided hydrogen atoms to scavenge fluoride radicals.Yamada et al.(2oo5) later published a similar laboratory-scale study that considered the combustion of PFAS-impregnated textilesat $1 { , } 0 0 0 ^ { \circ } \mathrm { C } ,$ $8 5 \%$ excess air,and a2 s residence time.The focus of the study was to ascertain whether combustion of the PFAS-impregnated material would result in PFOA emissions.Neither PFOA nor PICs were detected under nonideal combustion performance measured by a high carbon monoxide emission of 650 part per million (ppm).HF was not detected,but silicon tetrafluoride $\mathrm { ( S i F _ { 4 } ) }$ ）was, suggesting the HF was reacting with the silica-based lining of the reactor.

Consideration has also been given to incineration of activated carbon used for removing fluorinated alkyl compounds from water. A review conducted by Schultz et al.(2003) reported industry correspondence stating that incineration of the saturated activated carbon for $2 \ s$ with a combustion chamber reaching temperatures of $1 { , } 2 0 0 ^ { \circ } \mathrm { C }$ was sufficient for destruction,and the exhaust gas could be scrubbed to produce a solid $\mathrm { C a F } _ { 2 }$ precipitate.Taylor et al. (20l4) examined whether combustion of gasified fluorotelomer-based polymer would emit PFOA at $1 { , } 0 0 0 ^ { \circ } \mathrm { C } ,$ in an oxidizing atmosphere,with a $2 \ : s$ residence time to reflect municipal and medical waste incinerator conditions.No detectable quantities of PFOA were measured in the exhaust gas,and qualitative HF emission suggested complete mineralization occurred.

# Full-scale incineration studies

A few full-scale studies have been published on the fate of PFAS compounds through incineration systems with only two considering an SSI.Loganathan et al. (2oo7) investigated eight PFAS compounds through two WRRFs. One of the facilities employed incineration,and while not stated in the published information, the furnace was most likely an MHF based on the facility geography. The PFAS compounds were measured in dewatered solids fed to the incinerator and in the ash.No mention was made on the operating conditions of the furnace or whether the bottom or fly ash was sampled.Findings indicated a significant removal of the measured PFAS compounds; however,some compounds were still detected in the ash in the range of single to double digit nanogram per gram concentrations. Concentrations of PFOS,PFOA,perfluorooctane sulfonamide (PFOSA),and perfluorodecanoic acid (PFDA) were all detected in the ash above method detection limits and ranged from $2 6 \%$ to $9 7 \%$ less than values measured in dewatered solids on a concentration basis,except in two samples.Interestingly, two of the ash samples yielded higher PFAS concentrations, one PFOS and one PFOSA,than in the dewatered solids. The authors did not speculate on the reasons for the increased concentrations for these two analytes.

A second study is currently underway at an SSI facility employing an FBF (MacGregor, 2020). The temperature and gas residence time within the FBF were reported at $8 3 0 ^ { \circ } \mathrm { C }$ and 8 s,respectively. Samples were taken at all inputs and outputs of the SSI system and analyzed quantitatively for 28 PFAS.Only partial results were available at the time of this literature review, restricted to the solids and liquids streams around the SSI.

Preliminary results show that mass flows were reduced through the SSI processes for all quantitated PFAS,with the exception of 6:2 fluorotelomer sulfonate. The degree of destruction was not characterized because water used in the air pollution control systems contained PFAS and may mask the levels emitted by the furnace.Release of the ambient air and stack emissions data in the near future will help to further determine the fate of PFAS through the SSI. The authors also noted that the inorganic fluoride content of the wet scrubber discharge water was over l0,ooo times that of the influent flow plus the measured PFAS fed to the FBF,assuming mineralization.The authors suggest there are significant loads of nonmeasured PFAS being combusted through the SSI.

No other studies have been published on SSIs,but limited information can be found in other industries.Two studies investigated the behavior of polymerized PFAS through incinerators.Lemieux et al. (2007) reported on the USEPA's study of feeding carpet treated with fluorotelomer products into a pilot-scale rotary kiln furnace operating at $9 5 2 { - } 9 9 8 ^ { \circ } \mathrm { C }$ The emitted PFAS detected,primarily PFOA and perfluorohexanoic acid (PFHxA),did not change between operating with the carpet feed or on natural gas alone,suggesting contamination with fluoropolymers used in sampling or analytical equipment. Aleksandrov et al. (2019) investigated emissions from a pilotscale rotary kiln incinerator with a waste heat boiler and flue gas cleaning compliant with German emissions regulations. The incinerator was fed a mixture of PTFE and wood chips with supplemental natural gas. Two combustion conditions were evaluated with conditions in the afterburner ranging from $8 7 0 ^ { \circ } \mathrm { C }$ with $_ \mathrm { ~ 4 ~ s ~ }$ of residence time to $1 { , } 0 2 0 ^ { \circ } \mathrm { C }$ and $2 . 7 \ s$ of residence time.In either condition, the combined rotary kiln and afterburner excess air was $1 4 3 \%$ .A total of 31 PFAS compounds were quantified,and 1l were detected in the air emissions but not at significantly different levels than that measured in control runs without PTFE,which suggests sampling and analytical contamination.The authors concluded that incineration of PTFE at the conditions studied would not release PFAS to the environment at measurable levels.

Japan's Ministry of Environment (2013) released a report on PFOS behavior through a full-scale municipal solid waste incinerator operating at $1 { , } 1 0 0 ^ { \circ } \mathrm { C }$ in the rotary kiln and $9 0 0 ^ { \circ } \mathrm { C }$ in the afterburner with a combined gas residence time of $_ { 8 \mathrm { ~ s ~ } }$ and solids residence time in the rotary kiln of $1 . 0 { - } 1 . 5 \mathrm { ~ h ~ }$ Flue gas traveled through a wet scrubber and wet electrostatic precipitator to achieve emissions standards. Canisters of firefighting foam with known quantities of PFOS were fed to the incinerator. The overall PFOS destruction efficiency was over $9 9 . 9 9 9 \%$ considering levels emitted in the flue gas,ash residues,or scrubber water discharge.The report also mentioned that flue gas emissions of fluoric carbons from the furnace,scrubber exhaust,or stack were undetectable,but did not define which compounds were analyzed.

Sandblom (2014) sampled the various streams into and out of four municipal solid waste incinerators in Sweden operating at temperatures over $8 5 0 ^ { \circ } \mathrm { C }$ .Several of the nine PFAS compounds targeted were measured in the slag and fly ash streams in the single nanogram per gram $\mathrm { ( n g / g ) }$ range with perfluorononanoic acid (PFNA） consistently dominating. Levels observed in the wet scrubber discharge ranged from nondetect to single-digit $\mathrm { n g / L }$ concentrations. Stack emissions were not characterized.

More recently, PFAS destruction of greater than $9 9 . 9 9 9 \%$ for five PFAS through a thermal oxidizer and four-stage scrubbing system was reported at a Chemours chemical facility in North Carolina (Focus Environmental Inc., 2020).The thermal oxidizer treated waste gas streams laden with PFAS at temperatures exceeding $1 { , } 0 0 0 ^ { \circ } \mathrm { C } ,$ though neither residence time nor PICs were noted.

A recent study investigating the incineration of PFAS contaminated soils observed extensive destruction (NRC Alaska LLC,2019).Contaminated soils from a military installation in Alaska were incinerated through a rotary kiln fitted with a secondary combustion chamber. The kiln was operated at 425- $8 1 5 ^ { \circ } \mathrm { C }$ with the exact temperature depending on the soil characteristics.The secondary combustion chamber temperature ranged from 980 to $1 { , } 2 0 0 ^ { \circ } \mathrm { C } .$ No mention of retention times in either the kiln or secondary chamber was noted.Exhaust gases were quenched and filtered in a baghouse.One of the two trials included a packed bed scrubber after the baghouse.Samples of the contaminated and treated soil, exhaust gases,and flue gas scrubbing water were analyzed for specific PFAS compounds. For two test trials,the PFAS was typically nondetect in treated soil samples;however,a few samples did exhibit detectable levels of PFOS or PFHxS.Emissions from the incineration systems exhibited detectable levels of various PFAS but further evaluation found the XAD traps used in the sampling train and the supply water for the scrubbing system both contained background levels of PFAS.The authors concluded the emissions results were impacted and could not completely predict the background contamination in the reported results.Given the limited data provided in the report,a destruction efficiency could not be calculated.Interestingly, inclusion of the packed bed scrubber during the second test did not change PFAS emissions suggesting the PFAS evaluated are not captured in this type of emission control equipment.

Solo-Gabriele etal. (2020) studied PFAS in landfill leachate; three leachates came from landfills dominated by MSW ash.A statistically significant correlation between the concentration of PFAS in the leachate from landfills with ash and the operating temperature range of the incinerator ( $\boldsymbol { R } ^ { 2 } = 0 . 9 2$ $ { p } = 0 . 0 0 8 )$ was observed. The lowest total PFAS concentrations $( < 3 , 4 0 0 ~ \mathrm { n g / L } )$ were found in leachate fromash where the incinerators operated between 930 and $9 8 0 ^ { \circ } \mathrm { C }$ .The incinerator with the lowest operating temperatures ( $7 6 0 { - } 8 7 0 ^ { \circ } \mathrm { C } )$ exhibited the highest PFAS leachate concentrations $( 1 2 , 3 0 0 { - } 1 3 , 5 0 0 ~ \mathrm { n g / L } )$ ： The third landfill,dominated by MSW ash supplied by an incinerator operating in the range of $8 1 5 { - } 8 7 0 ^ { \circ } \mathrm { C } ,$ ，had total PFAS from 8,400 to $8 { , } 7 0 0 ~ \mathrm { n g / L }$ . The main difference between the two leachates from ash originating from incinerators operating in lower temperature ranges was perfluorobutane sulfonate (PFBS). The four-carbon PFAS was highest (roughly ${ 5 , 0 0 0 \mathrm { n g / L } }$ in the low-temperature versus the mid-temperature incinerator by approximately $3 5 0 ~ \mathrm { n g / L }$ . The authors proposed the lower temperature incineration may be producing shorter chain PFAS instead of proportionately destroying all PFAS. The study did not disclose the type of furnace used at these facilities or additional operating conditions beyond temperature.

Where full-scale incineration of PFAS-laden wastes at hazardous waste conditions has been investigated, it is important to note that wastes are highly concentrated (e.g., spent activated carbon used for aqueous PFAS removal and aqueous firefighting foam).The Resource Conservation and Recovery Act (RCRA) labels a waste“hazardous"when it contains at least $0 . 1 \%$ percent of a halogenated organic chemical. For comparison,the highest levels of a PFAS compound (PFOS) identified in wastewater solids,given substantial contributions from an industrial discharger, is $0 . 0 0 0 5 \%$ percent (Sun et al., 2011; USEPA,2005; Yu et al.,2009).

# Thermal by-product formation

Reports of PFAS treatment using thermal technologies on a variety of matrices provides some indication of potential thermal degradation by-products.Many bench and pilot studies have looked at the decomposition of specific PFAS congeners and by-product identification.By-product identification is complicated by the broad characteristics involving polar or nonpolar,anionic,cationic,or zwitterionic,and volatile, semi-volatile,or nonvolatile forms PFAS can take,so not all by-products can be detected. Several studies identified thermal PFAS degradation by-products as summarized in Table 4. These studies show that PFAS will decompose at temperatures relevant to operating conditions of SSIs although by-product formation will be a concern.

These studies demonstrate that an array of by-products is possible during thermal treatment of PFAS.Given the diverse chemical species potentially formed as by-products,the currently available analytical methods based on a small number of targeted PFAS compounds are inadequate for following the fate of PFAS through thermal processes.

Little is currently known regarding the formation pathways for by-products from PFAS combustion. Burgess et al. (1995) presented theoretical pathways for one- and two-carbon fluorinated species. Even when limiting consideration to these two simplest PFAS,the possible degradation products and intermediates are extensive. The study considered the formation of longer-chain compounds from simpler radicals suggesting reformation is possible.Garcia et al. (2oo7) proposed PTFE would decompose to tetrafluroethene $\mathrm { ( C _ { 2 } F _ { 4 } ) }$ under reducing conditions and potentially reform as $\mathrm { C } _ { 3 } \mathrm { F } _ { 6 } ,$ which would then combust to $\mathrm { C F _ { 4 } }$ .No further discussion on reformation of PFAS or other compounds of concern from PFAS combustion was identified in available literature.

The formation of polychlorinated dibenzo-p-dioxins (PCDD)and polychlorinated dibenzofurans (PCDF) in incineration systems may provide a valuable analogy, keeping in mind that the bond energies reported in Table 2 indicate large differences between $\mathrm { C - C l }$ and $\mathrm { C - F }$ bonds. The PCDD/PCDF compounds are typically not present in wastewater solids but are often detected in incinerator emissions.McKay (2002) provides an extensive review of PCDD/PCDF emissions from municipal solid waste incineration.Formation of PCDD/PCDF compounds was noted at approximately $4 0 0 ^ { \circ } \mathrm { C } .$ which is not a typicaltemperature for SSI operations unless the facility includes a waste heat boiler.Two formation pathways likely for PCDD/ PCDF formation include:(a） precursor compounds from incomplete combustion of chlorobenzenes and chlorophenols or (b）de novo pathway forming PCDD/PCDF from simpler compounds in the flue gas.Either pathway requires chlorine to halogenate the complex organic molecules.Furthermore, ash from wastewater incinerators has been shown to promote PCDD/PCDF formation if chlorine is present,or catalyze oxidation in its absence (Fullana et al.,2oo4).The complex chemistry in incineration systems may promote similar formations for PFAS-related compounds and will require further study to determine pathways to measured end products.

# PROSPECTIVE SSI PFASFATE

Despite their reputation, PFAS compounds will combust during incineration. Early laboratory-scale work by Taylor and Yamada (20o3) showed that PFOS will combust in a nonturbulent laboratory-scale reactor within the same temperature range that an SSI operates.Aleksandrov etal.(2o19)conducted thermogravimetric analyses(TGA）of PTFE that exhibited complete destruction in $< 1$ sat $8 0 0 ^ { \circ } \mathrm { C } ,$ similar to SSI temperature regimes.Khan et al.(202O) calculated a PFOS half-life of $_ { 0 . 2 s }$ at $7 2 6 ^ { \circ } \mathrm { C }$ 、MacGregor (2020) reported PFAS is being destroyed through an FBF SSI ( $8 3 0 ^ { \circ } \mathrm { C }$ for $8 \ s$ ）based on mass flows into and out of the incineration system though the stack emissions have yet to be characterized.At higher temperatures, more typical of hazardous waste incinerators,significant PFAS destruction has been reported for a variety of congeners (Focus Environmental Inc., 202o; Lemieux et al.,2007; Ministry of the Environment of Japan,2013; NRC Alaska LLC,2019; Taylor et al.,2014; Yamada et al.,20o5).The existing published literature is too narrow to determine whether all PFAS combust under incineration conditions given analytical limitations.Further, the potential reduction in combustion efficiency of the studied PFAS at typical SSI temperatures has not been characterized. However, given the turbulent environments and long residence times of the FBF and MHF at least some destruction is expected to occur.

The type of PFAS may also determine combustion efficiency within an incinerator. In contrast to the PFAS mentioned in the previous paragraph, $\mathrm { C F _ { 4 } }$ may require over $1 { , } 4 0 0 ^ { \circ } \mathrm { C }$ for complete destruction (Tsang et al.,1998).In the case of the investigation by Loganathan et al. (20o7),nonpolymeric PFAS (PFHxS,PFNA,PFOA,PFOS,PFOSA,PFDA, perfluoroundecanoic acid [PFUnDA],and perfluorododecanoic acid [PFDoDA]) would have likely dominated the incinerator feed, which resulted in some PIC levels in the ash.By comparison, both Lemieux et al. (2007) and Aleksandrov et al. (2019) studied systems deliberately incinerating polymeric forms of PFAS and did not observe any significant PIC formation. Likewise, Taylor et al.(2014) indicated the combustion of a fluorotelomer-based polymer produced no PICs.While there is inadequate information available to verify a trend,polymeric PFAS may combust more efficiently than nonpolymer forms.

Formation of PICs during PFAS incineration at temperatures achieved in SSIs has not been well documented. In the SSI study by Loganathan et al. (20o7),some ash samples reported higher levels of PFAS than that measured in the wastewater solids fed to the incinerator.If the volatile solids content of the wastewater solids fed to the incinerator was over $6 5 \%$ then despite the high concentrations in the ash the overall mass of each PFAS was reduced. Otherwise,this may be a result of sampling time and wastewater solid PFAS variability, transformation of precursor compounds to the measured PFAS,or sampling and analytical contamination. In studies of other combustion systems,contamination has been suggested as the source of quantifiable PICs in ash,air emissions, and scrubber water (Aleksandrov et al.,20l9; Lemieux et al., 2007; NRC Alaska LLC,2019).However, Sandblom (2014) and Solo-Gabriele et al. (2020) reported ash PFAS levels from MSW incinerators operating with similar temperature ranges as SSIs. SSIs,especially the FBF, will promote more turbulence than a typical moving grate incinerator used in MSW incineration and may therefore increase the relative level of PFAS destruction. Lastly, the available work only concerns PFAS that can be quantified,leaving unaccounted the vast majority of PFAS. Overall, no incineration system is $1 0 0 \%$ efficient,but the level of PICs released by SSIs is likely low compared to other environmental PFAS contamination pathways and whatever reduction occurs results in an overall reduction in global PFAS environmental discharge.

Characterizing PICs will provide the necessary context for concern from both a public health and a greenhouse gas (GHG） perspective.For example,while $\mathrm { C F _ { 4 } }$ has been identified as a potential PIC with a high GHG impact but no health concerns, potential emission rates from an SSI are low. Ifa large urban SSI facility processing lOo dry tons per day converted $5 0 \%$ of the PFAS load to $\mathrm { C F _ { 4 } } ,$ the unchecked emissions would be equivalent to the emissions of one passenger vehicle.This estimate assumed the PFAS wastewater solids content based on New England Biosolids and Residuals Association (NEBRA) and New Hampshire Department of Environmental Services (NHDES) PFAS sampling data summarized by Rainey (2019). As environmental and legislative bodies have introduced calls to ban SSI operation due to concerns over the impact of PICs, understanding the makeup and levels emitted would provide necessary data for the developing regulatory landscape.

The PFAS content of wastewater solids and characteristics thereof must also be taken into consideration in context to other incineration operations.Incinerating PFAS compounds with hydrocarbon-rich fuel sources may improve destruction efficiency. Narengerile et al. (2010) calculated the destruction of hydrofluorocarbons in thermal plasma with and without water. In the presence of water, which supplied hydrogen and oxygen radicals,fluorocarbon by-products were eliminated.Watanabe et al.(2018) observed more than a $2 0 \%$ increase in recovered mineralized fluorine when adsorbed to GAC compared with thermally treating the PFAS reagents alone at $7 0 0 ^ { \circ } \mathrm { C }$ in a nitrogen atmosphere.The chemistry with GAC or other hydrocarbon fuels may be responsible for the enhanced PFAS destruction. Wang et al.(20l3） observed higher PFOS destruction rates when subjecting lime-treated wastewater solids to $3 0 0 ^ { \circ } \mathrm { C }$ compared with adding calcium hydroxide to PFOS alone (Wang et al.,2011). The authors speculated the enhanced thermal degradation could be due to catalyzing metals in the wastewater solids.Taylor and Yamada (20o3) hypothesized that PFOS combustion with methane provides the required hydrogen atoms to scavenge fluorine radicals to prevent PFAS reformation.Yamada et al.(2oo5） observed combustion temperatures required for no PIC formation were lower with a PFAS-impregnated textile compared with the PFAS alone.Because the level of PFAS in biosolids is several orders of magnitude less than that required for RCRA hazardous waste classification and lower than MSW (Sanborn Head, 2019), PFAS destruction through an SSI may outperform other incineration industries,especially given the characteristics of the wastewater solids.

(enuiiutg)   
  

<html><body><table><tr><td>PARENT PFAS</td><td></td><td>TREATMENT</td><td></td><td>FLUORINATED BY-PRODUCTS NOTEDA</td></tr><tr><td>REFERENCE NRC Alaska (2019)</td><td>PFOS and PFOA (measured in contaminated soil sample)</td><td>TEMPERATURE 425-815C (kiln) 980-1,200℃</td><td>ATMOSPHERE Oxidizing</td><td>PFBA,PFPeA,PFHxA,PFHpA,PFOA, PFNA,PFDA,PFDOA,PFTeA,</td></tr><tr><td></td><td>PFOA,PFOS,PFHxS,PFNA,PFBS,and</td><td>(secondary combustion) 1,000°℃</td><td></td><td>PFBS,FOSA,PFUnA,PFHxS,PFOS, NMeFOSAA,NEtFOSAA, 6:2 FTS PFBA,PFBS,PFPeA,PFHxA,PFHxS,</td></tr><tr><td></td><td>PFHpA</td><td>700°℃</td><td></td><td>PFHpA, PFOA,PFOS,PFNA, PFDA, PFUnA,PFDoA Incomplete balance suggests volatile organo-</td></tr><tr><td>Watanabe et al. (2018) Watanabe et al. (2016)</td><td>PFOA,PFHxA (on GAC)</td><td>800℃</td><td>Reducing Reducing</td><td>fluoro compounds PFPeA,PFBA</td></tr><tr><td></td><td>PFOS (on GAC)</td><td>900℃ 1,000°℃ 700-1,000°℃C</td><td></td><td>PFBA None None</td></tr><tr><td>Garcia et al. (2007)</td><td>PTFE</td><td>750℃ 850℃ 950℃ 1,050C</td><td>Oxidizing</td><td>CF4, C2F, benzoylfluoride CF4,C2F6 CF4, CF,C3F6,benzenepentafluoro CF4, C2F6, benzenepentafluoro</td></tr><tr><td>Yamada et al. (2005)</td><td>Fluorotelomer-based acrylic polymer (C0.33H 0.40O0.04F0.19Cl0.04)</td><td>600°℃ 1,000℃</td><td>Oxidizing</td><td>Flurobenzene, difluorobenzene, ·CF3, ·CF2CH=CH2 ·CF,CF2CH=CH2</td></tr><tr><td>Krusic et al. (2005)</td><td>Treated polyester fiber (2% Fby weight) PFOA</td><td>725℃ 307°℃</td><td>Vacuum</td><td>.CF3 Perfluoro-1-heptene</td></tr><tr><td>Krusic and Roe (2004)</td><td></td><td>355-385℃ 196-234℃</td><td>Vacuum</td><td>1-H-perfluoroheptane,perfluoro-1-heptene 1-H-perfluoroheptane</td></tr><tr><td>Ells et al. (2003)</td><td>Ammonium PFOA PTFE</td><td>550℃</td><td>Oxidizing</td><td>fluoroacids</td></tr><tr><td>Taylor and Yamada (2003)</td><td>PFOS</td><td>600°℃</td><td>Oxidizing</td><td>CF4 or C2F6 (postulated),1,1-difluroethene CF4 0r C2F6 (postulated)</td></tr><tr><td>Ellis et al. (2001)</td><td>PTFE</td><td>900℃ 500℃</td><td>Oxidizing</td><td>Tetrafluoroethene, hexafluoropropene, trifluoroacetate,cyclo-octafluorobutane,</td></tr><tr><td>Conesa and Font (2001)</td><td></td><td></td><td></td><td>CF3(CF2)nCOOH,CF3O(CF2)mCOOH, monofluoracetic acid, difluoroacetic acid C2F2,C2F4,CF4, CHF, CHF2, CF, ·CFO,</td></tr><tr><td></td><td></td><td></td><td>Oxidizing</td><td>CH2F2, cyclo-C4Fg,C3F3</td></tr><tr><td>Simon and Kaminsky</td><td>PTFE</td><td>500-600℃C</td><td>Reducing Reducing</td><td>same Trifluroethylene,hexafluroproprene,</td></tr></table></body></html>

<html><body><table><tr><td>REFERENCE</td><td>PARENTPFAS</td><td>TREATMENT TEMPERATURE</td><td>ATMOSPHERE</td><td>FLUORINATED BY-PRODUCTS NOTEDA</td></tr><tr><td>Jun et al. (1995)</td><td>PTFE</td><td>510-600℃</td><td>Reducing</td><td>Tetrafluoroethylene,hexafluroproprene, cyclo-octafluorobutane</td></tr><tr><td>Baker and Kasprzak (1993)</td><td>PTFE</td><td>400°℃</td><td>Oxidizing</td><td>Tetrafluoroethylene, hexafluropropylene, trifluoroacetyl fluoride, fluoroform, perfluoroisobutylene</td></tr><tr><td>Blake and Tomlinson (1971)</td><td>Fluoroacetic acid</td><td>295-382C</td><td>Vacuum Reducing</td><td>hexafluropropylene,perfluoroisobutylene Fluoroacetyl fluoride</td></tr><tr><td> Sheppard and Sharts</td><td>Perfluoroalkanoic acid</td><td>550℃</td><td>Not identified</td><td>Perfluoroalkenes, hydrogen fluoride</td></tr><tr><td>(1969),Kissa (2001)</td><td>Perfluoroalkanoic potassium salt</td><td>165-200℃</td><td></td><td>Perfluoroalkenes</td></tr><tr><td>Scheel et al. (1968)</td><td>PTFE</td><td>550℃</td><td>Reducing</td><td>Carbonyl fluoride</td></tr><tr><td>Lewis and Naylor (1947)</td><td>PTFE</td><td>600-700℃</td><td>Reducing</td><td>Tetrafluoroethylene</td></tr></table></body></html>

For those SSIs using an adsorption technology for mercury removal (i.e.,activated carbon or SPC),further PFAS removal is also expected.Activated carbon represents one of the main treatment technologies applied to aqueous streams (Horst et al., 2018).Activated carbon is widely used in incinerators,including SSIs,to remove organic pollutants such as PCDDs and PCDFs from flue gas (Niessen,2002). The relatively new SPC technology marketed for mercury and sulfur dioxide removal may also remove PCDDs and PCDFs,which is just being explored (EnviroCare International & personal communication,2020). The potential PFAS removal provided by these air pollution control technologies would further reduce environmental release from an SSI.

# RESEARCH NEEDS

The current scientific knowledge on the behavior of PFAS through thermal processes is limited and requires additional study to understand how to best address public concerns and best practices for disposing of contaminated material.A nearterm study on the fate of PFAS through SSIs,like the study being finalized by MacGregor (2020) but looking at both MHF and FBF technologies is crucial and recommended. Sampling and analytical techniques that are available for identifying a broad spectrum of PFAS will be useful in developing a materials balance for such a study (Winchell et al.,in review).While these initial full-scale studies will provide the gross fate of PFAS through SSIs and assist regulators and policy makers to respond to public pressure,additional research will be required to better understand the mechanisms behind the observed SSI performance and subsequently develop implementable solutions.

One of the more basic areas of research needed is identifying the diversity of PFAS present in wastewater solids.As noted in Table 2,theoretical calculations (Burgess et al.,1995; Tsang et al.,1998)and laboratory data(Taylor& Yamada,2oo3;Yamada et al.,20o5) both illustrate the impacts of PFAS chemical structure on thermal degradation. Simply stated, thermal conditions for destruction will in part depend on the specific PFAS present.As analytical techniques develop,improved characterization of the PFAS in wastewater solids will provide the industry with key compounds to target in development and operation of treatment methods.

Additional research must also focus on the nature of thermal degradation of PFAS under SSI operating conditions. Existing research has largely focused on operating conditions in hazardous waste incinerators,which differ from SSIs.Table 1 summarizes the different operating conditions between several types of incinerators.Although SSIs operate at lower temperatures than hazardous waste facilities,the SSI often use longer residence times and higher turbulence critical to PFAS destruction.Laboratory and pilot-scale research focused on MHF and FBF technologies,under controlled and representative conditions,would provide immensely valuable information on PFAS destruction efficiency.In part, these scaled down studies can evaluate different operating conditions for optimizing PFAS destruction without creating issues with other pollutant emissions or treatment goals.

Additional research should also focus on the complex combustion chemistry resulting from use of wastewater solids as a fuel source.Several studies have indicated using hydrocarbon fuel sources increases PFAS destruction eficiency (Taylor & Yamada,2003;Yamada etal.,2005).Others observed positive impacts from the addition of calcium (Wang et al.,2013). Further research may identify catalysts to enhance PFAS destruction and lead to engineered solutions.

Emerging thermal treatment technologies,such as hydrothermal liquefaction or pyrolysis,operate under different conditions compared with existing SSIs.Given these technologies are under active development, their performance regarding PFAS destruction is also unknown. These technologies require separate research directives but can also be complementary to SSI research.Based on the emerging technologies discussed in this review, one key area differentiated from SSIs will be PFAS thermal degradation in the absence of or in substoichiometric oxygen conditions.

# CONCLUSIONS

Thermal treatment of PFAS through an SSI represents a potential wastewater solids process for destroying PFAS; however, significant questions remain regarding both the destruction efficiency and potential formation of undesirable by-products. While nearly complete PFAS decomposition has been demonstrated at temperatures representative of SSI operation, byproducts have also been observed.Temperature is only one of the three primary parameters when assessing destruction capacity in combustion systems,the other two being residence time and turbulence.A well-functioning SSI will submit PFAS to greater residence times and mixing (or turbulence) than the laboratory-scale research performed to date, further promoting PFAS destruction. If PFAS parent compounds are recalcitrant or PICs are formed, they will be subjected to air pollution control equipment,which will likely capture an additional fraction of PFAS compounds.

Consequently,a critical near-term need exists to evaluate the fate of PFAS through full-scale SSIs to understand the fate of the PFAS in the wastewater solids and identify PICs in stack emissions and air pollution control residual streams.Initial testing should focus on sites representative of SSI industry operating conditions and configurations. Subsequent fullscale testing must consider operational changes or various air pollution control technologies to minimize PFAS emissions.Furthermore,an extensive database on PFAS content in wastewater solids at incineration facilities would inform the utilities of their PFAS loadings.Results should be compared among studied emissions to ascertain site-specific risks.Any of these research objectives must incorporate emerging analytical techniques to characterize the PFAS to the fullest extent, while using sampling techniques capable of collecting polar and nonpolar, as well as volatile,nonvolatile, and semi-volatile PICs.A comprehensive review of the sampling and analytical techniques available for utilizing these emerging techniques has been prepared separately (Winchell et al., in review).

# CONFLICTS OF INTEREST

In submitting this manuscript, the authors do not have any conflicts of interest or other considerations that would limit publication of the manuscript.Martha J.M.Wells is a chemical consultant to Brown and Caldwell and served in that role while assisting with preparation of this manuscript.

# DATA AVAILABILITY STATEMENT

Data sharing is not applicable to this article as no datasets were generated or analyzed during the current study.

# REFERENCES

Albertson,O.E.(1992).Sludge incineration: Thermal destructionof residues (manualof practice FD-i9)(1st ed.).: Water Environment Federation.   
Aleksandrov, K.,Gehrmann,H.J.,Hauser, M.,Matzing,H.,Pigeon,D., Stapf,D.,& Wexler,M.(20l9).Waste incineration of Polytetrafluoroethylene (PTFE） to evaluatepotential formation of per-and Poly-Fluorinated Alkyl Substances (PFAS) in flue gas.Chemosphere,226,898-906.https://doi.org/10.1016/j.chemo sphere.2019.03.191   
Alonso,F.,Beletskaya,I.P.,& Yus,M. (2o02).Metal-mediated reductive hydrodehalogenation of organic halides.Chemical Reviews,102(11),4009-4091.htps://doi. org/10.1021/cr0102967   
Arvaniti, O.S.,& Stasinakis,A. S.(2015).Review on the occurrence,fate and removal of perfluorinated compounds during wastewater treatment. Science of the Total Environment,524-525,81-92.https://doi.org/10.1016/j.scitotenv.2015.04.023   
ASTDR(20l8).Toxicological Profile for Per-andPolyfluoroalkyl Substances:Draft for public comment.Retrieved from https://www.atsdr.cdc.gov/toxprofiles/tp200.pdf   
Baker,B.B.,& Kasprzak,D.J.(1993). Thermal degradation of commercial fluoropolymers in air.Polymer Degradation and Stability,42(2),181-188.https://doi. org/10.1016/0141-3910(93)90111-U   
Beu,L.S. (2005).Reduction of Perfluorocompound (PFC) Emissions:2005 State-ofthe-Technology Report.International Sematech Manufacturing Initiative.   
Bioforcetech (2020).Eliminating PFAS from biosolids isno longera mystery.Retrieved from https://medium.com/nature-is-awesome-bioforcetech/eliminating-pfas-frombiosolids-is-no-longer-a-mystery-f56b94d7bfb   
Blake,P.G.,& Tomlinson,A.D.(1971). Thermal decomposition of fluoroacetic acid. Journal of the Chemical Society B:Physical Organic,1596,1596-1597.https://doi. org/10.1039/j29710001596.   
Buck,R.C.,Franklin,J.,Berger,U.,Conder,J,Cousins,I.T,deVoogt,,Jnen,.A., Kannan,K.,Mabury,S.A.,& van Leeuwen,S.P.J. (2ol1).Perfluoroalkyl and polyfluoroalkylsubstances intheenvironment: Terminology,classification,andorigins. IntegratedEnvironmentalAssessmentand Management,7(4),513-541.htps://doi. org/10.1002/ieam.258   
Burgess，D.R.,Zachariah,M.R.，Tsang,W.,& Westmoreland,P.R.(1995). Thermochemicaland chemical kinetic data for fluorinated hydrocarbons.Progress in Energy and Combustion Science,21(6),453-529.htps://doi.org/10.1016/0360- 1285(95)00009-7   
Chen,Y.-C.,Lo,S.-L,Li,N.-H.,Lee,Y.-C.,& Kuo,J. (2013).Sorption of perfluoroalkyl substances (PFASs) onto wetland soils.Desalination and Water Treatment,51(40- 42),7469-7475. https://doi.org/10.1080/19443994.2013.792145   
Clara,M.,Scheffknecht, C.,Scharf, S.,Weiss,S.,& Gans,O.(2008).Emissions of perfluorinated alkylated substances (PFAS) from point sources- Identification of relevant branches.Water Science and Technology,58(1),59-66.https://doi.org/10.2166/ wst.2008.641   
Conesa,J.A,Font,.).lytetraforethlenedecopositioniirdt gen.PolymerEngineeingndScience41(12),3747.htps://door/1/ pen.10908   
Cordner,A.,De La Rosa,V.Y.,Schaider,L.A.,Rudel,R.A.,Richter,L.,& Brown,P.(2019). Guideline levels for PFOA and PFOS in drinking water: The role of scientific uncertainty,risk assessment decisions,and social factors.Journal of Exposure Science and Environmental Epidemiology,29(2),157-171. htps://doi.org/10.1038/s4137 0-018-0099-9   
Dauchy，X.(2019).Per-andpolyfluoroalkylsubstances(PFASs)indrinkingwater Current state of the science.Current Opinion in Environmental Science Health,7, 8-12.https://doi.org/10.1016/j.coesh.2018.07.004   
Dimzon,KeldJl,CeleV). Sampling and simultaneous determination of volatile per- and polyfluoroalkyl substances in wastewater treatment plant air and water.Analytical and Bioanalytical Chemistry,409(5),1395-1404.https://doi.0rg/10.1007/s00216-016-0072-1   
Elis,D.A.,Mabury,S.A.,Martin,J.W,&Muir,D.C.G.(201).Thermolysisfflu ropolymers as a potential source of halogenated organic acids in the environment. Nature,412(6844),321-324.https://doi.org/10.1038/35085548   
Ellis,D.A.,Martin,J.W.,Mabury,S.A.,Hurley,M.D.,Sulbaek Andersen,M.P.,&Walington, T.J. (2003).Atmospheric lifetime of fluorotelomeralcohols.Environmental Science and Technology,37(17),3816-3820.https://doi.org/10.1021/es034136j   
EnviroCare International (2020).Personal Communication.   
Eriksson, U.,Haglund,P.,& Kärrman,A. (2ol7).Contribution of precursor compounds to the release of per-and polyfluoroalkyl substances (PFASs) from waste water treatment plants (WWTPs).Journal of Environmental Sciences,61,80-90.htps://doi. org/10.1016/j.jes.2017.05.004   
Focus Environmental Inc (2020). Thermal oxidizer performance test report: Chemours company fayetteville works.Retrieved from https://www.chemours.com/en/-/media/ files/copateeiite   
Fullna,A.,Conesa,J.A.,Font,R.,& Sidhu,S.(2004).Formation and destruction of chlorinated pollutants during sewage sludge incineration. Environmental Science and Technology38(10),2953-2958.htps://doirg/10.1021/es034896u   
Gallen,C.,Eaglesham,G.,Drage,D,Nguyen,T.H,&Mueler,J.F(28).Amse timate of perfluoroalkyl substance (PFAS)release from Australian wastewater treatment plants. Chemosphere,208,975-983．htps://doi.org/10.1016/j.chemo sphere.2018.06.024   
Gao,N.,Kamran,K.,Quan, C.,& Willams,P.T. (2020). Thermochemical conversion of sewage sludge:A critical review.Progress in Energy and Combustion Science,79, 100843.https:///1/jpcs   
Garcia,A.N., Viciano,N.,& Font,R.(2oo7).Products obtained in the fuel-rich combustion of PTFEat high temperature.Journal of Analytical and Applied Pyrolysis,80(1), 85-91.https://doi.org/10.1016/j.jaap.2007.01.004   
Guo,R.,Sim,W.J.,Lee,E.S.,Lee,J.H.,&Oh,J.E.(2010).Evaluation of the fate of perfluoroalkyl compounds inwastewater treatment plants.Water Research,44(11), 3476-3486.https://doi.org/10.1016/j.watres.2010.03.028   
Hamid, H.,& Li,L. (20l6).Role of wastewater treatment plant (WWTP) in environmental cycling of poly-and perfluoroalkyl (PFAS) compounds.Ecocycles,2(2),43-53. https://doi.org/10.19040/ecocycles.v2i2.62   
Heidrich,E.S., Curtis,T.P.,& Dolfing,J. (2011).Determination of the internal chemical energy of wastewater.Environmental Scienceand Technology,45(2),827-832.https:// doi.org/10.1021/es103058w   
Horst,J.,McDonough,J.,Ross,I.,Dickson,M.,Miles,J.,Hurst,J.,& Storch,P.(2o18).Water treatmentechnologiesforPFAS:Thenextgeneration.GroundwaterMonitoringand Remediation,38(2),13-23.hps://doi.org/10.111/gwmr.12281   
ITRC (2020).Per-and Polyfluoroalkyl Substances (PFAS).Retrieved from Technical/ Regulatory Guidance website: https://pfas-1.itrcweb.org/   
Jun,H.S.,Kim,K.N.,Park,K.Y,&Woo,S.I.(1995).Thermal degradation of polytetrafluoroethylene in flowing helium atmosphere II.Product distribution and reaction mechanism. Korean Journal of Chemical Engineering,12(2),183-187. htps://doi. org/10.1007/BF02705644   
Kamarehie,B.,Jafari,A.J.,& Mahabadi, H.A.(2014).Dechlorination and decomposition of Aroclorl242 in real waste transformer oil using a nucleophilic material withamodified domestic microwave oven.Journal of Material Cycles and Waste Management4)ps://s   
Kenedy,E,Kai,L,lugogorski,,&oel,J (99).ermalndatalytichro dehalogenationofhalon1301withmethane.HalonOptionsTechnical Working Conference,(May),-6.   
Khan,M.Y.,So,S.,& da Silva,G.(2020).Decomposition kinetics of perfluorinated sulfonic acids.Chemosphere,238,124615.https://doi.org/10.1016/j.chemo sphere.2019.124615   
Kim,J. H.,Ok,Y.S.,Choi, G.H.,& Park,B.J. (2015).Residual perfluorochemicals in the biochar from sewage sludge.Chemosphere,134,435-437.https://doi.org/10.1016/j. chemosphere.2015.05.012   
Kim Lazcano,R.,de Perre,C.,Mashtare,M.L.,& Lee,L.S.(2019).Per-and polyfluoroalkylsubstances in commercially available biosolid-based products:The effect of treatment processes.Water Environment Research,91(12),i669-1677. htps://doi. org/10.1002/wer.1174   
Kinsman,L.,Grant,G., Murray, C.,Fournie,T.,Rashwan,T.,Patch,D.,&Gerhard,J.I. (2020).Smoldering combustion: An alternative for management of biosolids containing PFAS.WEF Residuals and Biosolids Conference 2020 Proceedings,407-413.   
Kissa,E.(2oo1).Fluorinated surfactants and repelents (2nd ed.).Marcel Dekker Inc..   
Krusic,P.J., Marchione,A.A.,& Roe,D.C.(2005).Gas-phase NMR studies of the thermolysis of perfluorooctanoic acid.Journal ofFluorine Chemistry,126(11-12),1510- 1516.https://doiorg/10.016/j.fluchem.005.08.016   
Krusic,P.J,&Roe,D.C. (2004).Gas-phase NMR technique forstudying thethermolysis of materials: Thermal decomposition of ammonium perfluorooctanoate.Analytical Chemistry,76(13),3800-3803.https://doi.org/10.1021/ac049667k   
Kucharzyk,K.H.,Darlington,R.,Benoti,M.,Deeb,R.,&Hawley,E.(20l7).Novel ratment technologies for PFAS compounds: A critical review.Journal of Environmental Management,204,757-764. https://doi.org/10.1016/j.jenvman.2017.08.016   
Kuehnel,M.F,Lentz,D.,& Braun,T.(2013). Synthesis of fluorinated building blocks bytransition-metal-mediated hydrodefluorination reactions.Angewandte Chemie -International Edition,52(12),3328-3348.https://doi.org/10.1002/anie.201205260   
Lee,H., Tevlin,A.G.,Mabury, S.A.,& Mabury, S.A. (20l4).Fate of polyfluoroalkyl phosphate diesters and their metabolites in biosolids-applied soil: Biodegradation and plant uptakein greenhouse and field experiments.Environmental Science and Technology,48(1),340-349.https://dorg/10.1021/es403949z   
Lee,M.C.,& Choi, W. (2oo2).Efficient destruction of CF4 through in situ generation of alkali metals from heated alkali halide reducing mixtures.Environmental Science and Technology,36(6),1367-1371.htps://doi.org/10.1021/es010698w   
Lee,Y.C.,Lo,S.L., Kuo,J.,& Huang, C.P.(20l3).Promoted degradation of perfluorooctanic acid by persulfate when adding activated carbon.Journal of Hazardous Materials,26,46-469.hps:/oog/16/jhmat5   
Lee,Y.C.,Lo,S.L., Kuo,J,&Lin,Y.L.(2012).Persulfate oxidation of perfluorooctanoic acidunderthetemperaturesof $2 0 { - } 4 0 ^ { \circ } \mathrm { C }$ ChemicalEeingJal 27-32.https://doorg/10.16/j.cej.2012.05.073   
Lemieux,P.M., Strynar, M.,Tabor, D.G.,Wood,J.,Cooke,M.,Rayfield,B.,Kariher,P. (2007).Emissions offluorinated compounds from the combustion of carpeting.2007 InternationalConferenceonIncinerationandTheralTreatmentTechnologiesAir & Waste Association.   
Lewis,F.M.(2oo8).Combustion fundamentals.Proceedings of the Water Environment Federation Residuals and Biosolids Conference,1064-1088.   
Lewis,E.E.,& Naylor,M.A.(1947).Pyrolysis of Polytetrafluoroethylene.Journal of the American Chemical Society,69(8),1968-1970.htps://doi.org/10.1021/ja01200a039   
Lindstrom,A.B.,Strynar, M.J.,Delinsky,A.D.,Nakayama,S.F.,McMillan,L,Libelo, E.L.,Neill,M,&Thomas,L.(201i).Applicationof WWTPbiosolidsandresulting perfluorinated compound contamination of surface and well water in Decatur, Alabama, USA.Environmental Science and Technology,45(19),8015-8021.https:// doi.org/10.1021/es1039425   
Loganathan,B.G.Sajwan,K.S.Sinclair,E.,SenthilKumar,K.,&Kannan,K.(00). Perfluoroalkyl sulfonates and perfluorocarboxylates in two wastewater treatment facilities in Kentucky and Georgia.Water Research,41(20),4611-4620. https://doi. org/10.1016/j.watres.2007.06.045   
MacGregor,I.(2020).PFAS emitted froma wastewater treatment plant with sewage sludge incinerator.Great Lakes Virtual PFAS Summit.Retrieved from https://www.michi gan.gov/egle/09429,7-135-3308_333-518324.ml   
Major,D.(2019).Demonstration of smoldering combustion treatment of PFAS-impacted investigation-derivedwaste:SERDPprojectER18-1593.   
Maric,J.,BerdugoVilches,T.,Pissot,S.,CaeteVela,I,Gyllenhammar,M.,&Seemnn, M.(2020).Emissions of dioxins and furans during steam gasification of Automotive Shredder residue; experiences from the Chalmers 2-4-MW indirect gasifier.Waste Management,102,1i4-121.https://doi.org/10.1016/j.wasman.2019.10.037   
Mckay, G.(2oo2).Dioxin characterisation,formation and minimisation during municipal solid waste (MSW) incineration: Review. Chemical Engineering Journal,86,343-368.   
Ministry of the Environment of Japan (2013).Summary ofthe guideline on the treatment ofwastes containing perfluorooctane sulfonic acid (PFOS),and its saltsin Japan. Retrieved from htp://www.env.go.jp/en/focus/docs/files/201304-89.pdf   
NACWA (2010).Renewableenergy resources: Bankingonbiosolids.   
Nakayama,S.F,oshaneOodaYUsaaY,Iaimadaag M.,Kobayashi,Y,&Isobe,T(2019).Worldwide trendsitracingpoly-adper fluoroalkyl substances (PFAS) in the environment.TrAC-Trends in Analytical Chemistry:/g/jac   
Narengerile, Saito,H.,& Watanabe,T.(20lo).Decomposition mechanism of fluorinated compounds in water plasmas generated under atmospheric pressure.Plasma Chemistry and Plasma Processing,30(6),813-829.https://doi.org/10.1007/s1109 0-010-9259-y   
Niessen,W.R. (2002).Combustion and incineration processes (3rd ed.).Marcel Dekker Inc..   
NRC (1996).Review and evaluation of alternative chemical disposal technologies.https:// doi.org/10.17226/5274   
NRC Alaska LLC (2019).Moose creek facility thermal remediation of PFAS-contaminated soil.Retrieved from htps://dec.alaska.gov/media/1876l/nrc-moose-creek-facilitypfas-sep-2019-case-study-v3f-191101.pdf   
OECD (2o02).Hazard assesment of perfluorooctane sulfonate (PFOS) and its salts.Cooperation on ExistingChemicals.Retrieved fromhtp://www.oecd.org/chemicalsa fety/risk-assessment/2382880.pdf   
OECD (2018).Towardanew comprehensiveglobal databaseofper-and polyfluoroalkyl substances (PFASs): Summary report on updating the OECD 2007 list of per- and polyfluoroalkyl substances (PFASs).Series on Risk Management,No.39.(39),1-24. Retrieved from http://www.oecd.org/officialdocuments/publicdisplaydocumentpdf/cote=ENV-JM-MONO(2018)7&doclanguage=en   
Oliaei,F,Kriens,DWeber,R,& Watson,A.(0l3).PFOSandPFCreleasesandss ciated polltion froma PFC production plant in Minnesota (USA).Environmental Science and Pollution Research,20(4),1977-1992.https://doi.org/10.1007/s1135 6-012-1275-4   
Oppelt,E.T.(1987).Incinerationofhazardous wasteacritical review.Journal of the AirPollutionCotroloiat7()5hs://194 630.1987.10466245   
Pan,C.G.,Liu, Y.S.,& Ying,G.G.(20l6).Perfluoroalkyl substances (PFASs) in wastewater treatment plants and drinking water treatment plants: Removal efficiency and exposure risk.Water Research,106,562-570.https://doi.org/10.1016/j. watres.2016.10.045   
Pancras,T.,Schrauwen,G.,Held,T.,Baker,K.,Ros,I.,&Slenders,H.(2o16).Environmental fate and effcts of polyand perfluoroalkyl substances (PFAS).CONCAWE Reports.   
Pinder,R.(2ol2).Treated biosolids in a hot hydrogen environment (master's thesis).The University of Guelph.   
Post,G.B,GeoJA,CoeK.R7).Keentifsuineoing drinkingwater gudelines for perfluoroalkylacids:Contaminantsof emerging concern.PLoS Biology,15(12),1-12.https://doi.org/10.1371/journal.pbio.2002855   
Rainey, M.(2019).NEBRA Literature Review: PFAS $\llangle$ Wastewater Residuals.Retrieved from htps://www.nebiosolids.org/pfas-residuals   
Rashwan,T.L,Gerhard,J.,&Grant,G.P.(2016).Applicationofself-sustaining smoul deringcombustionforthedestructionofwastewaterbiosolids.WasteManagement, 50,201-1s:/j   
Rayne,S.,&Forest,K. (209).Perfluoroalkylsulfonicandcarboxylicacids:Acritical review of physicochemical properties,levels and patterns in waters and wastewaters, and treatment methods.JournalofEnvironmental Science and Health,PartA,44(12), 1145-1199.https://doi.org/10.1080/10934520903139811   
Reed,R.J.(1978).North American Combustion Handbook:A basic referenceon the art and science of industrial heating with gaseous and liquid fuels (2nded.).Cleveland, OH: North American Mfg.Company.   
Rey,L.,Conesa,J.A.,Aracil,I.,Garrido,M.A.,&Ortuno,N.(2016).Pollutant formation in the pyrolysis and combustion of Automotive Shredder Residue.Waste Management, 56,376-383.https://doi.org/10.1016/j.wasman.2016.07.045   
Ross,I,Mconough,J,iles,,orch,P,elaatKchunaranan,P,Klve,E Hurst,J,S.Dasgupta,S.,& Burdick,J. (2018).Areviewof emerging techologies forremedatoof.Remedatio28(2)10126.htps://dog/0 rem.21553   
Sanborn Head (2019).PFASwaste sourcetestingreport.Retrieved fromhtps://anrweb. vt.gov/PubDocs/DEC/SolidWaste/OL510/OL5102019.10.15NEWSVTPFASSou rceTestingRpt-Final.pdf   
Sandblom,O.(2014).Waste incineration as a possible source ofperfluoroalkyl acids to the environment-method development and screening (Stockholm University).Retrieved from http://su.diva-portal.org/smash/get/diva2:1261025/FULLTEXT01.pdf   
Scheel,LDln,WE,e,C.68).iilero Pyrolysis Products-Including Carbonyl Fluoride and a Reaction Product, Silicon Tetrafluoride.American Industrial HygieneAssociation Journal,29(1),41-48.https:// doi.org/10.1080/00028896809342979   
Schultz,M.M.,Barofsky,D.F.,& Field,J.A.(2003).Fluorinated alkyl surfactants. EnvironmentalEngineering Science,20(5),487-50l.htps://doiorg/10.1089/10928 7503768335959   
Schultz, M.M.,Higgins,C.P,Huset,C.A.,Luthy,R.G.,Barofsky, D.F.,& Field,J.A. (2006).Fluorochemical mass flowsinamunicipal wastewater treatment facility Environmental Science and Technology,40(23),7350-7357. https://doi.org/10.102i/ es061025m   
Sheppard,W.A.,& Sharts,C.M.(1969).Organic Fluorine Chemistry.New York,NY:W. A. Benjamin.   
Simon,C.MKamsky,W.998).Cemicalrecylingofpolyetrafluoroeby pyrolysis.PolymerDegradationandStability62(1),-7.htps://doiorg/10.1016/ S0141-3910(97)00097-9   
Solo-Gabriele,H.M.,Jones,A.S.,Lindstrom,A.B.,& Lang,J.R.(2020).Waste type,incineration,andaerationare associated with per-and polyfluoroalkyllevels in landfill leachates.Waste Management,107(May 2016),191-200.htps://doi.org/10.1016/j. wasman.2020.03.034   
StandardofPerformanceforNewStationarySourcesandEmisionGuidelinesforExisting Sources:Sewage Sludge Incineration Units.76FedReg.S15,372(finalrule March 21, 2011) (codified at 40 C.FR.pt. 60).   
Sun,H.,Gerecke,A.C.,Giger, W.,& Alder,A.C.(2011).Long-chain perfluorinated chemicalsindigetedseagesudgesiniterland.Environmentalollution9(2) 654-662.hs://o   
Swedish Chemical Agency (2015).Occurrence and use of highly fluorinated substances and alternatives.Retrieved from https://www.kemi.se/en/global/rapporter/2015/repor t-7-15-occurrence-and-use-of-highly-fluorinated-substances-and-alternatives.pdf   
Takata,M.,Watanabe,N.,& Yamamoto,S.(2015).Destruction of organic Cland Br compounds through incineration enhanced by alkali and alumina addition. Journal of Material Cycles and Waste Management,17(2),282-289.https://doi.org/10.1007/ s10163-015-0359 $\mathbf { x }$   
Takemine,S.,Takata,M.,Yamamoto,S.,Watanabe,N.,Matsumura,C.,Fuji,S.,& Kondo, A.(2013).Thermal behavior of perfluorooctanoic acid adsorbed on granular activatedcarbonsekKagku62hps:/og/1016nsea aku.62.107   
Taylor,P.H,&Yamada,T.(20o3)，Laboratory-scalethermaldegradationofper fluoro-octanyl sulfonateand related precursors.Final Report,3M Company, UDR-TR-03-00044, USEPA EDocket OPPT-203-0012-00151.   
Taylor,P.H.,Yamada,T.,Striebich,R.C.,Graham,J.L.,& Giraud,R.J.(2014).Investigation of waste incinerationoffluorotelomer-based polymers asa potential source of PFOA in the environment.Chemosphere,110,17-22. https://doi.org/10.1016/j.chemo sphere.2014.02.037   
TheGreens/EFAintheEuropeanParliament(0l9).Mediabriefing:Trilogueresultsfthe revisionoftheDrkigaerDiectiveRetrieedfrotps:/eniegde content/uploads/2019/12/Media-briefing-Drinking-water-19.12.2019.pdf   
Toor, S.S.,Rosendahl,L.,& Rudolf,A.(2011).Hydrothermal liquefaction of biomass: A review of subcritical water technologies.Energy,36(5),2328-2342.https://doi. org/10.1016/j.energy.2011.03.013   
Tsang,W.,Burgess,D.R.,& Babushok,V.(1998).On the incinerability of highly fluorinated organic compounds. Combustion Science and Technology,139(1),385-402. https://doi.0rg/10.1080/00102209808952095   
Ueno,H.,Iwasaki,Y.,Tatsuichi, S.,& Soufuku,M.(1997).Destruction of chlorofluorocarbons in a cement kiln.Journal of theAireWaste Management Association,47(11), 1220-1223.https://doi.0rg/10.1080/10473289.1997.10464068   
UNEP (2009).SC-4/17:Listing of perfluorooctane sulfonic acid (PFOS),its salts and perfluorooctanesulfonyl fluoride (PFOSF) inAnnex Bof the Stockholm Convention on persistent organicpollutants.Retrieved from htp://chm.pops.int/Implementation/ IndustrialPOPs/PFOS/Overview/tabid/5221/Default.aspx   
UNEP(2ol8).Risk profileon perfluorohexane sulfonic acid (PFHxS),itssalts and and PFHxS-related compounds.htps://doi.org/10.2307/2668517   
UNEP (2019a). General technical guidelines on the environmentally sound management of wastes consisting of,containing or contaminated with persistent organic polutants. Conferenceof thePartiestotheBasel Conventiononthe ControlofTransboundary Movementsdelteeti https://doi.0rg/10.1017/cbo9780511793677.033   
UNEP (2019).SC-9/12:Listingof perfluorooctanoicacid (PFOA),itssaltsandArelated compounds.Retrieved from http://chm.pops.int/TheConvention/Conference oftheParties/Meetings/COP9/tabid/7521/Default.aspx   
United Kingdom Department for Environment Food & Rural Affairs (2013).Incineration ofmunicipal solid waste.New Technologies.Retrieved from https://www.gov.uk/ government/publications/incineration-of-municipal-solid-waste   
Urano,K.,Kato,M.,Kimura,C.,& Tasaki, T.(2011).Decomposition of CFCs/HCFC inanindustrial waste incineration facility.Journal ofJapan Society forAtmospheric Environment/TaikiKankyo Gakkaishi,32(5),331-340.https://doi.org/10.11298/taiki 1995.32.5_331   
USEPA (2005).Guidance and summary of information regarding the RCRA usedoil rebuttable presumption.   
USEPA (2020).EPA's per-and polyfluoroalkyl substances (PFAS) action plan.Retrieved fromhtps://www.epa.gov/sites/production/files/2020-01/documents/pfas_action_ plan_feb2020.pdf   
USEPA (2020).PFAS master listof PFAS substances.Retrieved from Chemical Lists website:https://comptox.epa.gov/dashboard/chemical_lists/pfasmaster   
USEPA (2020). Energy recovery from the combustion of municipal solid waste (MSW). Retrieved from https://www.epa.gov/smm/energy-recovery-combustion-municipal-solid-waste-msw   
USEPA (2020c).Per- and Polyfluoroalkyl Substances (PFAS): Incineration to managePFAS waste streams background.In Technical Brief: Innovative Research for a Sustainable Future.https://doi.org/10.1080/00102209808952095   
Venkatesan,A.K.,& Halden,R.U. (20l3).National inventory of perfluoroalkyl substances inarchived U.S.biosolids from the 2oo1EPANational Sewage Sludge Survey.Journal of HazardousMaterials,25253,41-48.hps://oorg/106/jhzma013.0.16   
Viswanathan, S.,DiMassimo,R.,Zhao,H.,Perry，T.,Yamada,T.,Kahandawala,M., & Morgan,A. (2020). Thermal treatment of PFAS contaminated sludge: experimentation,designconsiderationandchallenges.Proceedingsof theWater Environment Federation Residuals and Biosolids Conference,905-915.https://doi. org/10.2175/193864718824829217   
Wang,B.,Yao,Y,Chen,H.,Chang,S.,Tian,Y,&Sun,H.(202).Per-andpolyfuoroalkyl substances and the contribution of unknown precursors and short-chain (C2-C3) perfluoroalkyl carboxylic acids at solid waste disposal facilities. Science of the Total Environment,705,135832. htps://doi.org/10.1016/j.scitotenv.2019.135832   
Wang,F.,Lu,X.,Li,X.Y.,& Shih,K. (2015).Effectiveness and mechanisms of defluorination of perfluorinated alkyl substances by calcium compounds during waste thermal treatment. Environmental Science and Technology,49(9),5672-5680.htps://doi. org/10.1021/es506234b   
Wang,F.,Lu,X.,Shih,K.,&Liu, C.(2011).Influence of calcium hydroxide on the fate of perfluorooctanesulfonate under thermal conditions.Journalof Hazardous Materials, 192(3),1067-1071.https://doi.org/10.1016/j.jhazmat.2011.06.009   
Wang,F.,Shih,K.,Lu,X.,& Liu, C.(2013).Mineraliztion behaviorof fluorine in perfluorooctanesulfonate (PFOS) during thermal treatment of lime-conditioned sludge. EnvironmentalScienceandTechnology,47,26-627.   
Wang,J.(2017).Smouldering Combustion of Biosolids from Wastewater Treatment Plants (WWTPs) (Murdoch University).Retrieved from https://researchrepository.murdo ch.edu.au/id/eprint/40482/1/wang2017.pdf   
Wang,Y.,Yu,N.,Zhu,X.,Guo,H.,Jiang,J,Wang,X.,& Wei,S.(2018).Suspect and nontarget screening of per-and polyfluoroalkyl substances in wastewater from a fluorochemical manufacturing park. Environmental Science and Technology,52(19), 11007-11016.htps://oiorg/10.021/acs.est.8b03030   
Wang,Z.,Cousins,I.T.,Scheringer,M.,& Hungerbuehler,K.(2015).Hazard assessment of fluorinated alternatives to long-chain perfluoroalkyl acids (PFAAs) and their precursors:Statusquoongoingchallengesand possblesolutions.Environment International,75,172-179.https://doi.org/10.1016/j.envint.2014.11.013   
Wang,Z,Dewi,J.C.,Higgins,C.P.,&Cousins,I.T. (27).Anever-ending stof per-and polyfluoroalkylsubstances (PFASs)?Environmental Science and Technology, 51(5),2508-2518.https://doi.org/10.1021/acs.est.6b04806 Watanabe,N., Takata,M., Takemine,S.,& Yamamoto,K.(2o18).Thermal mineralization behavior of PFOA,PFHxA,and PFOS during reactivation of granular activated carbon (GAC) in nitrogen atmosphere.Environmental Science and Pollution Research,   
25(8),7200-7205.https://doi.org/10.1007/s11356-015-5353-2 Watanabe,N., Takemine,S., Yamamoto,K.,Haga,Y.,& Takata,M. (20l6).Residual organic fluorinated compounds from thermal treatment of PFOA,PFHxA and PFOS adsorbed onto granular activated carbon (GAC).Journal ofMaterial Cycles and Waste Management,18(4),625-630.https://doi.org/10.1007/s10163-016-0532-x WEF(20o9).Wastewater Solids Incineration Systems,Manualof PracticeNo.30 (1st ed.). https://doi.org/l0.1615/AtoZ.i.incineration Winchell,L.J.,Wells,M.J.M.,Ross,J.J.,Fonoll,X.,Norton,J.W.Jr,Kuplicki,S.,Kan, M.,& Bell, K.Y.(in review).Analyses of Per- and Polyfluoroalkyl Substances (PFAS) through the urban water cycle: Understanding aqueous,solid,and gaseous matrices in water and wastewater treatment. Yamada,T.,Taylor,PH.,Buck,R.C.,Kaiser,M.A.,&Giraud,R.J.(20o5).Thermal degradation of fluorotelomer treated articles and related materials. Chemosphere,61(7),   
974-984. https://doi.org/10.1016/j.chemosphere.2005.03.025   
Yin,K.,Gao,X.,Sun, Y., Zheng,L.,& Wang,W. (2013).Thermal degradation of hexachlorobenzene in the presence of calcium oxide at $3 4 0 { - } 4 0 0 ^ { \circ } \mathrm { C }$ Chemosphere,93(8), 1600-1606.https://doi.org/10.1016/j.chemosphere.2013.08.014   
Yu,J.,Hu,J.,Tanaka, S.,& Fujii, S.(2oo9).Perfluorooctane sulfonate (PFOS)and perfluorooctanoic acid (PFOA) in sewage treatment plants.Water Research,43(9),2399- 2408.https://doi.org/10.1016/j.watres.2009.03.009   
Yu,J.,Nickerson,A.,Li, Y.,Fang,Y.,& Strathmann,T.J. (202o).Fate of per-and polyfluoroalkyl substances (PFAS) during hydrothermal liquefaction of municipal wastewatertreatment sludge.Environmental Science:WaterResearch $\mathcal { C }$ Technology,6(5), 1388-1399.https://doi.org/10.1039/c9ew01139k   
Zhang,W.,Cao,H.,Mahadevan Subramanya,S., Savage,P.,&Liang,Y.(202o).Destruction of perfluoroalkylacidsaccumulated in Typha latifolia through hydrothermal liquefaction.ACS Sustainable Chemistry  Engineering,8,9257-9262. https://doi. org/10.1021/acssuschemeng.0c03249